/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.dataio.util.fenced;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.dataio.export.ExportException;
import com.ibm.es.nuvo.dataio.ingest.IngestException;
import com.ibm.es.nuvo.dataio.util.fenced.DataReceiver;
import com.ibm.es.nuvo.dataio.util.fenced.FencedErrorMessage;
import com.ibm.es.nuvo.dataio.util.fenced.FencedProcessException;
import com.ibm.es.nuvo.dataio.util.fenced.MessageBlock;
import com.ibm.es.nuvo.dataio.util.fenced.MessageContent;
import com.ibm.es.nuvo.dataio.util.fenced.ProcessConstants;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHandler
implements Runnable,
ProcessConstants {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger logger = ExtendedLogger.getLogger("com.ibm.es.nuvo." + MessageHandler.class.getName());
    protected InputStream dis = null;
    protected OutputStream dos = null;
    LinkedList<MessageContent> tmpStorage;
    static final int DEFAULT_MAX_STORAGESIZE = 10;
    private int maxStorageSize;
    Object tmpStorageLock;
    boolean receiver;
    DataReceiver dataReceiver;
    boolean isTerminated;
    Object isTermLock = new Object();
    private int serverPort;
    private ServerSocket serverSocket = null;
    public static final String LOCAL_HOST = "127.0.0.1";
    private final String serverHost;
    private Socket clientSocket = null;

    public MessageHandler() {
        this.serverHost = LOCAL_HOST;
        this.setTerminated(false);
    }

    public void setStreams(InputStream in, OutputStream out) {
        this.dis = in;
        this.dos = out;
    }

    public void init() throws IOException {
        this.init(null, 10);
    }

    public void init(DataReceiver dsr) throws IOException {
        this.init(dsr, 10);
    }

    public void term() {
        if (this.dis != null) {
            try {
                this.dis.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.dos != null) {
            try {
                this.dos.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.clientSocket != null) {
            try {
                this.clientSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void init(DataReceiver dsr, int maxsize) throws IOException {
        this.tmpStorage = new LinkedList();
        this.maxStorageSize = maxsize;
        this.tmpStorageLock = new Object();
        this.dataReceiver = dsr;
        this.receiver = dsr != null;
    }

    @Override
    public void run() {
        try {
            this.handleRequest();
        }
        catch (InterruptedException ie) {
        }
        catch (FencedProcessException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            StringBuffer buf = sw.getBuffer();
            MessageHandler.debugLog("FencedException" + buf.toString());
            logger.log(e);
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            StringBuffer buf = sw.getBuffer();
            MessageHandler.debugLog("FencedException" + buf.toString());
        }
    }

    void handleRequest() throws FencedProcessException, IOException, InterruptedException {
        if (this.receiver) {
            block8: while (!Thread.currentThread().isInterrupted()) {
                MessageBlock msgblk = this.readHeader();
                if (msgblk.getMessageType() == 3) {
                    this.term();
                    break;
                }
                int command = msgblk.getCommand();
                switch (command) {
                    case 1: {
                        IngestRequest request = this.readIngestRequest();
                        String inFile = request.getRequestedFilename();
                        Date baseDate = request.getBaseDate();
                        String userIdPath = request.getUserIdPath();
                        String userPass = request.getUserPass();
                        this.dataReceiver.ingesting(this.dos, inFile, baseDate, userIdPath, userPass);
                        continue block8;
                    }
                    case 2: {
                        this.readExportRequest();
                        continue block8;
                    }
                }
                throw new RuntimeException("INVALID OPERATION TYPE");
            }
        } else {
            MessageBlock msgblk;
            block9: while (!Thread.currentThread().isInterrupted() && (msgblk = this.readHeader()).getMessageType() != 3) {
                int command = msgblk.getCommand();
                MessageHandler.debugLog(msgblk.toDebugInfo());
                switch (command) {
                    case 1: {
                        int retCode = msgblk.getResult();
                        if (retCode == 0) {
                            int numOfDocuments = msgblk.getNumOfDocuments();
                            this.readIngestResult(numOfDocuments);
                            continue block9;
                        }
                        this.readInt();
                        int errCode = this.readInt();
                        ArrayList<String> errArgs = this.readErrorArguments();
                        MessageContent content = new MessageContent(errCode);
                        content.setErrMsgList(errArgs);
                        this.putResult(content);
                        continue block9;
                    }
                    case 2: {
                        int retCode = msgblk.getResult();
                        if (retCode == 0) {
                            this.readExportResult();
                            continue block9;
                        }
                        this.readInt();
                        int errCode = this.readInt();
                        ArrayList<String> errArgs = this.readErrorArguments();
                        MessageContent content = new MessageContent(errCode);
                        content.setErrMsgList(errArgs);
                        this.putResult(content);
                        continue block9;
                    }
                }
                throw new RuntimeException("INVALID OPERATION TYPE");
            }
        }
    }

    private IngestRequest readIngestRequest() throws FencedProcessException, IOException, InterruptedException {
        int status = this.readInt();
        if (status != 0) {
            throw new FencedProcessException(new RuntimeException("DOCUMENT_STATUS_NOT_SUCCESS TODO"));
        }
        HashMap<String, String> attrs = this.readAttribute();
        String requestFilename = attrs.get("filename");
        String userIdPath = attrs.get("useridpath");
        String userPass = attrs.get("userpassword");
        String baseDateStr = attrs.get("basedate");
        this.readContent();
        this.readAttachments();
        return new IngestRequest(requestFilename, this.longToDate(baseDateStr), userIdPath, userPass);
    }

    private void readExportRequest() throws FencedProcessException, IOException, InterruptedException {
        int status = this.readInt();
        if (status != 0) {
            throw new FencedProcessException(new RuntimeException("DOCUMENT_STATUS_NOT_SUCCESS TODO"));
        }
        HashMap<String, String> attrs = this.readAttribute();
        String requestFilename = attrs.get("filename");
        String appendStr = attrs.get("append");
        boolean append = false;
        if (appendStr != null && appendStr.equalsIgnoreCase("true")) {
            append = true;
        }
        ArrayList<String> list = this.readArrayContent();
        this.dataReceiver.exporting(this.dos, list.toArray(new String[0]), requestFilename, append);
    }

    private void readIngestResult(int numOfDocument) throws FencedProcessException, IOException, InterruptedException {
        for (int i = 0; i < numOfDocument; ++i) {
            int status = this.readInt();
            if (status == 1) {
                int errCode = this.readInt();
                MessageContent content = new MessageContent(errCode);
                this.putResult(content);
            } else if (status == 2) {
                this.putResult(null);
                return;
            }
            MessageContent content = new MessageContent();
            HashMap<String, String> attrs = this.readAttribute();
            content.setFields(attrs);
            content.setBuffer(this.readContent());
            List<MessageContent> attatchments = this.readAttachments();
            content.setAttachments(attatchments);
            this.putResult(content);
        }
        this.putResult(null);
    }

    private void readExportResult() throws InterruptedException {
        this.putResult(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageContent getResult(String uri, TaskType tt) throws IngestException, ExportException {
        MessageContent msgContent = null;
        Object object = this.tmpStorageLock;
        synchronized (object) {
            try {
                while (this.tmpStorage.isEmpty()) {
                    this.tmpStorageLock.wait(1000L);
                }
                msgContent = this.tmpStorage.removeFirst();
                if (msgContent != null && msgContent.isError()) {
                    int errCode = msgContent.getErrorCode();
                    ArrayList<String> errArgs = msgContent.getErrMsgList();
                    if (tt == TaskType.INGEST) {
                        errArgs.add(0, uri);
                        Message nMsg = FencedErrorMessage.getFencedErrorMessaage(errCode, errArgs, true);
                        throw new IngestException(nMsg);
                    }
                    Message nMsg = FencedErrorMessage.getFencedErrorMessaage(errCode, errArgs, false);
                    throw new ExportException(nMsg);
                }
                this.tmpStorageLock.notify();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        return msgContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putResult(MessageContent msgContent) throws InterruptedException {
        Object object = this.tmpStorageLock;
        synchronized (object) {
            while (this.tmpStorage.size() > this.maxStorageSize) {
                this.tmpStorageLock.wait(1000L);
            }
            this.tmpStorage.add(msgContent);
            this.tmpStorageLock.notify();
        }
    }

    private int readInt() throws FencedProcessException, IOException, InterruptedException {
        byte[] retbytes = this.readBytes(4);
        ByteBuffer bb = ByteBuffer.wrap(retbytes).order(BYTE_ORDER);
        return bb.getInt(0);
    }

    private MessageBlock readHeader() throws FencedProcessException, IOException, InterruptedException {
        byte[] recBlk = this.readBytes(32);
        MessageBlock replyMsg = new MessageBlock();
        replyMsg.readHeaderBlock(recBlk);
        return replyMsg;
    }

    private byte[] readBytes(int totalLength) throws IOException, FencedProcessException, InterruptedException {
        int restOfBytes;
        int rbyte;
        byte[] recBlk = new byte[totalLength];
        int nbyte = 0;
        for (restOfBytes = totalLength; restOfBytes > 0; restOfBytes -= rbyte) {
            rbyte = this.dis.read(recBlk, nbyte, restOfBytes);
            if (rbyte == -1) {
                if (!this.isTerminated()) break;
                throw new InterruptedException();
            }
            nbyte += rbyte;
        }
        if (restOfBytes != 0) {
            throw new FencedProcessException(new IOException("restBytes/TotalBytes = " + restOfBytes + "/" + totalLength));
        }
        return recBlk;
    }

    private HashMap<String, String> readAttribute() throws IOException, FencedProcessException, InterruptedException {
        HashMap<String, String> retList = new HashMap<String, String>();
        byte[] recBlk = this.readBytes(4);
        ByteBuffer bb = ByteBuffer.wrap(recBlk).order(BYTE_ORDER);
        int numOfItems = bb.getInt();
        for (int i = 0; i < numOfItems; ++i) {
            byte[] keyLenghtByte = this.readBytes(4);
            bb = ByteBuffer.wrap(keyLenghtByte).order(BYTE_ORDER);
            int keylen = bb.getInt(0);
            byte[] keyByte = this.readBytes(keylen);
            bb = ByteBuffer.wrap(keyByte).order(BYTE_ORDER);
            String key = new String(bb.array(), 0, keylen, "UTF-8");
            byte[] valLenghtByte = this.readBytes(4);
            bb = ByteBuffer.wrap(valLenghtByte).order(BYTE_ORDER);
            int vallen = bb.getInt(0);
            String val = "";
            if (vallen != 0) {
                byte[] valByte = this.readBytes(vallen);
                bb = ByteBuffer.wrap(valByte).order(BYTE_ORDER);
                val = new String(bb.array(), 0, vallen, "UTF-8");
            }
            retList.put(key, val);
        }
        return retList;
    }

    private byte[] readContent() throws IOException, FencedProcessException, InterruptedException {
        byte[] recBlk = this.readBytes(4);
        ByteBuffer bb = ByteBuffer.wrap(recBlk).order(BYTE_ORDER);
        int length = bb.getInt(0);
        if (length == 0) {
            return null;
        }
        byte[] content = this.readBytes(length);
        return content;
    }

    private ArrayList<String> readArrayContent() throws IOException, FencedProcessException, InterruptedException {
        byte[] recBlk = this.readBytes(4);
        ByteBuffer bb = ByteBuffer.wrap(recBlk).order(BYTE_ORDER);
        int length = bb.getInt(0);
        ArrayList<String> retList = new ArrayList<String>();
        BufferedReader isr = new BufferedReader(new InputStreamReader(this.dis));
        String line = null;
        int index = 0;
        while ((line = isr.readLine()) != null) {
            retList.add(line);
            if (++index != length) continue;
            break;
        }
        return retList;
    }

    private List<MessageContent> readAttachments() throws IOException, FencedProcessException, InterruptedException {
        byte[] recBlk = this.readBytes(4);
        ByteBuffer bb = ByteBuffer.wrap(recBlk).order(BYTE_ORDER);
        int numberOfAttachments = bb.getInt(0);
        ArrayList<MessageContent> attachments = new ArrayList<MessageContent>();
        for (int i = 0; i < numberOfAttachments; ++i) {
            MessageContent content = new MessageContent();
            HashMap<String, String> attrs = this.readAttribute();
            content.setFields(attrs);
            content.setBuffer(this.readContent());
            attachments.add(content);
        }
        return attachments;
    }

    private ArrayList<String> readErrorArguments() throws IOException, FencedProcessException, InterruptedException {
        ArrayList<String> retList = new ArrayList<String>();
        byte[] recBlk = this.readBytes(4);
        ByteBuffer bb = ByteBuffer.wrap(recBlk).order(BYTE_ORDER);
        int numOfItems = bb.getInt();
        for (int i = 0; i < numOfItems; ++i) {
            byte[] valLenghtByte = this.readBytes(4);
            bb = ByteBuffer.wrap(valLenghtByte).order(BYTE_ORDER);
            int vallen = bb.getInt(0);
            String val = "";
            if (vallen != 0) {
                byte[] valByte = this.readBytes(vallen);
                bb = ByteBuffer.wrap(valByte).order(BYTE_ORDER);
                val = new String(bb.array(), 0, vallen, "UTF-8");
            }
            retList.add(val);
        }
        return retList;
    }

    public synchronized void sendRequestIngesting(String inputFilename, Date baseDate, String userIdPath, String userPass) throws FencedProcessException {
        try {
            MessageBlock msg = new MessageBlock();
            msg.setMessageType(1);
            msg.setCommand(1);
            msg.setResult(0);
            msg.setNumOfDocuments(1);
            msg.setSender(4095);
            msg.setReceiver(Short.MAX_VALUE);
            msg.add("filename", inputFilename);
            if (userIdPath != null && userPass != null) {
                msg.add("useridpath", userIdPath);
                msg.add("userpassword", userPass);
            }
            if (baseDate != null) {
                msg.add("basedate", new Long(baseDate.getTime()).toString());
            } else {
                msg.add("basedate", "");
            }
            byte[] blk = msg.createHeaderBlock();
            MessageHandler.debugLog(blk);
            this.dos.write(blk, 0, blk.length);
            blk = MessageBlock.createIntBlk(0);
            MessageHandler.debugLog(blk);
            this.dos.write(blk, 0, blk.length);
            blk = msg.createAttributeBlock();
            MessageHandler.debugLog(blk);
            this.dos.write(blk, 0, blk.length);
            blk = MessageBlock.createIntBlk(0);
            MessageHandler.debugLog(blk);
            this.dos.write(blk, 0, blk.length);
            blk = MessageBlock.createIntBlk(0);
            MessageHandler.debugLog(blk);
            this.dos.write(blk, 0, blk.length);
            this.dos.flush();
        }
        catch (UnsupportedEncodingException uee) {
            new FencedProcessException(uee);
        }
        catch (IOException ioe) {
            new FencedProcessException(ioe);
        }
    }

    public synchronized Object sendRequestExporting(String[] uris, String outFile, Boolean append) throws FencedProcessException {
        try {
            MessageBlock msg = new MessageBlock();
            msg.setMessageType(1);
            msg.setCommand(2);
            msg.setResult(0);
            msg.setNumOfDocuments(1);
            msg.setSender(65280);
            msg.setReceiver(30719);
            msg.add("filename", outFile);
            msg.add("append", append.toString());
            byte[] blk = msg.createHeaderBlock();
            MessageHandler.debugLog(blk);
            this.dos.write(blk, 0, blk.length);
            blk = MessageBlock.createIntBlk(0);
            MessageHandler.debugLog(blk);
            this.dos.write(blk, 0, blk.length);
            blk = msg.createAttributeBlock();
            MessageHandler.debugLog(blk);
            this.dos.write(blk, 0, blk.length);
            blk = MessageBlock.createIntBlk(uris.length);
            MessageHandler.debugLog(blk);
            this.dos.write(blk, 0, blk.length);
            for (int i = 0; i < uris.length; ++i) {
                OutputStreamWriter osw = new OutputStreamWriter(this.dos, "UTF-8");
                osw.write(uris[i]);
                osw.write("\n");
                osw.flush();
            }
            this.dos.flush();
        }
        catch (UnsupportedEncodingException uee) {
            new FencedProcessException(uee);
        }
        catch (IOException ioe) {
            new FencedProcessException(ioe);
        }
        return new Object();
    }

    private boolean isTerminated() {
        return this.isTerminated;
    }

    private void setTerminated(boolean isTerminated) {
        this.isTerminated = isTerminated;
    }

    public synchronized void sendRequestTermination() {
        this.setTerminated(true);
        try {
            MessageBlock msg = new MessageBlock();
            msg.setMessageType(3);
            msg.setCommand(0);
            msg.setSender(4095);
            msg.setReceiver(Short.MAX_VALUE);
            byte[] blk = msg.createHeaderBlock();
            this.dos.write(blk, 0, blk.length);
            this.dos.flush();
        }
        catch (UnsupportedEncodingException uee) {
            new FencedProcessException(uee);
        }
        catch (IOException ioe) {
            new FencedProcessException(ioe);
        }
    }

    private static void debugLog(byte[] msg) {
    }

    private static void debugLog(String msg) {
    }

    public void setServerPort(int portNumber) throws SocketTimeoutException, IOException {
        this.startServer(portNumber);
        this.setServerSocketStream();
    }

    public int startServer(int portNumber) throws IOException {
        this.serverSocket = new ServerSocket(portNumber);
        if (this.serverSocket != null) {
            this.serverPort = this.serverSocket.getLocalPort();
        }
        return this.serverPort;
    }

    public void setServerSocketStream() throws SocketTimeoutException, IOException {
        this.serverSocket.setSoTimeout(30000);
        Socket socket = this.serverSocket.accept();
        this.dis = socket.getInputStream();
        this.dos = socket.getOutputStream();
    }

    public void setClientSocketStream(int portNumber) throws FencedProcessException {
        IOException finalException = null;
        int MAX_WAIT_LOOP = 50;
        for (int i = 0; i < 50; ++i) {
            try {
                this.clientSocket = new Socket(this.serverHost, portNumber);
                this.dis = this.clientSocket.getInputStream();
                this.dos = this.clientSocket.getOutputStream();
                finalException = null;
                break;
            }
            catch (IOException e) {
                finalException = e;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                continue;
            }
        }
        if (finalException != null) {
            throw new FencedProcessException(finalException);
        }
    }

    private Date longToDate(String dateAsLong) {
        if (dateAsLong == null) {
            return null;
        }
        if (dateAsLong.trim().equals("")) {
            return null;
        }
        return new Date(new Long(dateAsLong));
    }

    private class IngestRequest {
        private String requestedFilename;
        private String userIdPath;
        private String userPass;
        private Date baseDate;

        public IngestRequest(String requestedFilename, Date baseDate, String userIdPath, String userPass) {
            this.requestedFilename = requestedFilename;
            this.userIdPath = userIdPath;
            this.userPass = userPass;
            this.baseDate = baseDate;
        }

        public String getRequestedFilename() {
            return this.requestedFilename;
        }

        public String getUserIdPath() {
            return this.userIdPath;
        }

        public String getUserPass() {
            return this.userPass;
        }

        public Date getBaseDate() {
            return this.baseDate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TaskType {
        INGEST,
        EXPORT,
        NONE;

    }
}

