/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.dataio.util.fenced;

import com.ibm.es.nuvo.dataio.util.fenced.KeyValuePairBlock;
import com.ibm.es.nuvo.dataio.util.fenced.ProcessConstants;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public final class MessageBlock
implements ProcessConstants {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private int messageType;
    private int command;
    private int result;
    private int numOfDocuments;
    private int sender;
    private int receiver;
    private ArrayList<KeyValuePairBlock> attributeList;

    public MessageBlock() {
        this.clean();
    }

    public void clean() {
        this.setMessageType(0);
        this.setCommand(0);
        this.setResult(0);
        this.setNumOfDocuments(0);
        this.setSender(0);
        this.setReceiver(0);
        this.attributeList = new ArrayList();
    }

    public byte[] createHeaderBlock() {
        byte[] headerBlk = new byte[32];
        ByteBuffer bb = ByteBuffer.wrap(headerBlk);
        bb.order(BYTE_ORDER).putInt(this.getMessageType()).putInt(this.getCommand()).putInt(this.getResult()).putInt(this.getNumOfDocuments()).putInt(this.getSender()).putInt(this.getReceiver()).putInt(0).putInt(0);
        return headerBlk;
    }

    public void readHeaderBlock(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(BYTE_ORDER);
        int index = 0;
        this.setMessageType(bb.getInt(index));
        this.setCommand(bb.getInt(index += 4));
        this.setResult(bb.getInt(index += 4));
        this.setNumOfDocuments(bb.getInt(index += 4));
        this.setSender(bb.getInt(index += 4));
        this.setReceiver(bb.getInt(index += 4));
    }

    public void add(String k, String v) throws UnsupportedEncodingException {
        KeyValuePairBlock kv = new KeyValuePairBlock(k, v);
        this.attributeList.add(kv);
    }

    public byte[] createAttributeBlock() {
        int totalLength = 0;
        for (int i = 0; i < this.attributeList.size(); ++i) {
            totalLength += this.attributeList.get(i).getTotalLength();
        }
        byte[] msgBlk = new byte[totalLength += 4];
        int pointer = 0;
        byte[] numOfParamsBlk = new byte[4];
        ByteBuffer bb = ByteBuffer.wrap(numOfParamsBlk);
        bb.order(BYTE_ORDER).putInt(this.attributeList.size());
        int length = bb.array().length;
        System.arraycopy(bb.array(), 0, msgBlk, pointer, length);
        pointer += length;
        for (int i = 0; i < this.attributeList.size(); ++i) {
            KeyValuePairBlock bp = this.attributeList.get(i);
            byte[] tmpBytes = bp.createMemoryBlock();
            System.arraycopy(tmpBytes, 0, msgBlk, pointer, tmpBytes.length);
            pointer += tmpBytes.length;
        }
        return msgBlk;
    }

    public String toDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("Message");
        sb.append("\n");
        int val = this.getMessageType();
        sb.append("\t");
        switch (val) {
            case 0: {
                sb.append("MESSAGE_TYPE_UNKNOWN:" + val);
                break;
            }
            case 1: {
                sb.append("MESSAGE_TYPE_REQUEST:" + val);
                break;
            }
            case 2: {
                sb.append("MESSAGE_TYPE_REPLY:" + val);
                break;
            }
            case 3: {
                sb.append("MESSAGE_TYPE_TERMINATE:" + val);
                break;
            }
            default: {
                sb.append("MESSAGETYPE_ERROR:" + val);
            }
        }
        sb.append("\n");
        val = this.getCommand();
        sb.append("\t");
        switch (val) {
            case 0: {
                sb.append("COMMAND_NO_OPERATION:" + val);
                break;
            }
            case 1: {
                sb.append("COMMAND_INGEST_FILE:" + val);
                break;
            }
            case 2: {
                sb.append("COMMAND_EXPORT_FILE:" + val);
                break;
            }
            default: {
                sb.append("COMMAND_ERROR:" + val);
            }
        }
        sb.append("\n");
        val = this.getResult();
        sb.append("\t");
        switch (val) {
            case 0: {
                sb.append("RESULT_SUCCESS:" + val);
                break;
            }
            case 1: {
                sb.append("RESULT_FALSE:" + val);
                break;
            }
            case 2: {
                sb.append("RESULT_FATAL:" + val);
                break;
            }
            default: {
                sb.append("COMMAND_ERROR:" + val);
            }
        }
        sb.append("\n");
        val = this.getNumOfDocuments();
        sb.append("\t");
        sb.append("Number Of Documents:" + val);
        sb.append("\n");
        val = this.getSender();
        sb.append("\t");
        sb.append("Sender ID:" + Integer.toHexString(val));
        sb.append("\n");
        val = this.getReceiver();
        sb.append("\t");
        sb.append("Receiver ID:" + Integer.toHexString(val));
        sb.append("\n");
        return sb.toString();
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int mt) {
        this.messageType = mt;
    }

    public int getCommand() {
        return this.command;
    }

    public void setCommand(int c) {
        this.command = c;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int res) {
        this.result = res;
    }

    public int getReceiver() {
        return this.receiver;
    }

    public void setReceiver(int rec) {
        this.receiver = rec;
    }

    public int getSender() {
        return this.sender;
    }

    public void setSender(int sd) {
        this.sender = sd;
    }

    public int getNumOfDocuments() {
        return this.numOfDocuments;
    }

    public void setNumOfDocuments(int num) {
        this.numOfDocuments = num;
    }

    public static byte[] createIntBlk(int val) {
        byte[] blk = new byte[4];
        ByteBuffer bb = ByteBuffer.wrap(blk);
        bb.order(BYTE_ORDER).putInt(val);
        return blk;
    }
}

