/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.dataio.util.fenced;

import com.ibm.es.nuvo.dataio.util.fenced.ProcessConstants;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public final class BodyParameter
implements ProcessConstants {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String key;
    private String value;
    private byte[] keyBytes;
    private byte[] valBytes;
    public static final String BYTE_ENCODE_UTF8 = "UTF-8";

    public BodyParameter(String k, String v, String encode) throws UnsupportedEncodingException {
        this.key = k;
        this.value = v;
        this.keyBytes = null;
        this.valBytes = null;
        if (this.key == null || this.key.length() == 0) {
            throw new IllegalArgumentException("The key is null or empty.");
        }
        this.keyBytes = this.key.getBytes(encode);
        if (this.value != null && this.value.length() > 0) {
            this.valBytes = this.value.getBytes(encode);
        }
    }

    public BodyParameter(String k, String v) throws UnsupportedEncodingException {
        this(k, v, BYTE_ENCODE_UTF8);
    }

    public int getKeyLength() {
        int length = this.keyBytes != null ? this.keyBytes.length : 0;
        return length;
    }

    public int getValueLength() {
        int length = this.valBytes != null ? this.valBytes.length : 0;
        return length;
    }

    public int getTotalLength() {
        int length = 8;
        return length += this.getKeyLength() + this.getValueLength();
    }

    byte[] createMemoryBlock() {
        byte[] blk = new byte[this.getTotalLength()];
        ByteBuffer bb = ByteBuffer.wrap(blk);
        bb = bb.order(BYTE_ORDER).putInt(this.getKeyLength()).put(this.keyBytes).putInt(this.getValueLength());
        if (this.getValueLength() != 0) {
            bb.put(this.valBytes);
        }
        return blk;
    }
}

