/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.dataio.server;

import com.ibm.es.nuvo.dataio.util.fenced.ProcessConstants;
import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import lotus.domino.Database;
import lotus.domino.Document;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.NotesThread;
import lotus.domino.Session;

public class NotesExporter
implements ProcessConstants {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    Session session = null;
    Database database = null;
    String dbPath = "";
    private boolean isNotesThreadInitialized;

    private void recycleDocument(Document doc) {
        try {
            if (doc != null) {
                doc.recycle();
            }
        }
        catch (NotesException notesException) {
            // empty catch block
        }
    }

    private void recycleDatabase(Database db) {
        try {
            if (db != null) {
                db.recycle();
            }
        }
        catch (NotesException notesException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleDatabase() {
        try {
            if (this.database != null) {
                this.database.recycle();
            }
        }
        catch (NotesException notesException) {
        }
        finally {
            this.database = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleSession() {
        try {
            if (this.session != null) {
                this.session.recycle();
            }
        }
        catch (NotesException notesException) {
        }
        finally {
            this.session = null;
        }
    }

    public void recycleAll() {
        this.recycleDatabase();
        this.recycleSession();
    }

    public boolean connect(String databasePath, boolean append) {
        return this.connect(databasePath, "mail7.ntf", append);
    }

    public boolean connect(String databasePath, String templatePath, boolean append) {
        NotesThread.sinitThread();
        this.isNotesThreadInitialized = true;
        try {
            this.session = NotesFactory.createSession();
            NotesExporter.debugLog("session created");
            if (append) {
                NotesExporter.debugLog("getting old db");
                this.database = this.session.getDatabase(null, databasePath, false);
            }
            if (!append || this.database == null) {
                File oldDB = new File(databasePath);
                if (oldDB.exists()) {
                    File newDB;
                    int i = 1;
                    while ((newDB = new File(databasePath + "." + i)).exists()) {
                        ++i;
                    }
                    oldDB.renameTo(newDB.getAbsoluteFile());
                }
                NotesExporter.debugLog("getting template");
                Database maildb = this.session.getDatabase(null, templatePath, false);
                if (maildb != null) {
                    NotesExporter.debugLog("creating new db");
                    this.database = maildb.createFromTemplate(null, databasePath, false);
                    this.database.getAllDocuments().removeAll(true);
                }
            }
            if (this.database == null) {
                this.disconnect();
                return false;
            }
            this.dbPath = databasePath;
            NotesExporter.debugLog("connected");
        }
        catch (NotesException e) {
            NotesExporter.debugLog("exception connecting");
            this.recycleAll();
            NotesThread.stermThread();
            this.isNotesThreadInitialized = false;
            return false;
        }
        return true;
    }

    public void disconnect() {
        if (this.isNotesThreadInitialized) {
            NotesExporter.debugLog("disconnecting");
            this.recycleAll();
            NotesThread.stermThread();
            this.dbPath = null;
            this.isNotesThreadInitialized = false;
        }
    }

    public int exportURIs(String[] uris) {
        Object[] localURIs = (String[])uris.clone();
        Arrays.sort(localURIs);
        int docsReturned = 0;
        Database remoteDB = null;
        Object remoteDBname = null;
        for (int i = 0; i < localURIs.length; ++i) {
            String server = "";
            Object dbFile = "";
            String id = "";
            Object uri = localURIs[i];
            uri = ((String)uri).substring(((String)uri).indexOf("://") + 3);
            server = ((String)uri).substring(0, ((String)uri).indexOf("/"));
            NotesExporter.debugLog("server:" + server);
            uri = ((String)uri).substring(server.length() + 1);
            int index = ((String)uri).indexOf("?");
            if (index > 0) {
                dbFile = ((String)uri).substring(0, index);
                id = ((String)uri).substring(index + 4);
            } else {
                dbFile = uri;
            }
            NotesExporter.debugLog("dbFile:" + (String)dbFile);
            if (id.length() == 0) continue;
            Properties config = System.getProperties();
            if (config.getProperty("file.separator").equals("\\")) {
                dbFile = ((String)dbFile).replace('/', '\\');
            }
            try {
                Object newDBname = dbFile;
                if (remoteDBname == null || !((String)newDBname).equals(remoteDBname)) {
                    this.recycleDatabase(remoteDB);
                    remoteDB = this.session.getDatabase(null, (String)newDBname, false);
                    remoteDBname = newDBname;
                }
                Document doc = remoteDB.getDocumentByUNID(id);
                doc.copyToDatabase(this.database);
                ++docsReturned;
                this.recycleDocument(doc);
                continue;
            }
            catch (NotesException e) {
                // empty catch block
            }
        }
        this.recycleDatabase(remoteDB);
        return docsReturned;
    }

    private static void debugLog(String msg) {
    }
}

