/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.dataio.server;

import com.ibm.es.nuvo.dataio.ingest.IngestPredefinedMetaName;
import com.ibm.es.nuvo.dataio.server.NotesConstants;
import com.ibm.es.nuvo.dataio.util.fenced.ProcessConstants;
import java.io.InputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.EmbeddedObject;
import lotus.domino.Item;
import lotus.domino.Name;
import lotus.domino.NotesException;
import lotus.domino.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotesDocument
implements ProcessConstants,
NotesConstants,
IngestPredefinedMetaName {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    Hashtable<String, String> fields = null;
    Vector<Attachment> attachmentList = null;
    Iterator<Attachment> attachmentIter = null;
    Hashtable<String, String> attachMetadata = null;
    Attachment currentAttachment = null;
    Document origDocument = null;
    String content = "";
    Session session;

    public NotesDocument(Document document, Session notesSession) {
        this.origDocument = document;
        this.fields = new Hashtable();
        this.attachmentList = new Vector();
        this.session = notesSession;
        this.parseFields();
    }

    public Hashtable<String, String> getFields() {
        return new Hashtable<String, String>(this.fields);
    }

    public Document getDocument() {
        return this.origDocument;
    }

    public String getContent() {
        return this.content;
    }

    public boolean hasMoreAttachments() {
        if (this.attachmentList == null) {
            return false;
        }
        if (this.attachmentIter == null) {
            this.attachmentIter = this.attachmentList.iterator();
        }
        if (this.attachmentIter == null) {
            return false;
        }
        return this.attachmentIter.hasNext();
    }

    public boolean nextAttachment() {
        if (!this.hasMoreAttachments()) {
            return false;
        }
        this.currentAttachment = this.attachmentIter.next();
        this.attachMetadata = null;
        return this.currentAttachment != null;
    }

    public int getAttachmentCount() {
        if (this.attachmentList != null) {
            return this.attachmentList.size();
        }
        return 0;
    }

    public Hashtable<String, String> getAttachmentMetadata() {
        if (this.currentAttachment == null) {
            return null;
        }
        if (this.attachMetadata == null) {
            this.attachMetadata = new Hashtable();
            try {
                this.attachMetadata.put("ReplicaId", this.origDocument.getParentDatabase().getReplicaID());
            }
            catch (NotesException e) {
                this.attachMetadata.put("ReplicaId", "");
            }
            this.attachMetadata.put("filename", this.currentAttachment.getName());
            this.attachMetadata.put("contentsize", Integer.toString(this.currentAttachment.getFileSize()));
            this.attachMetadata.put("docdate", Long.toString(this.currentAttachment.getDate().getTime()));
            this.attachMetadata.put("docdateTimeZone", this.currentAttachment.getTimeZone());
        }
        return new Hashtable<String, String>(this.attachMetadata);
    }

    public InputStream getAttachmentStream() {
        if (this.currentAttachment == null) {
            return null;
        }
        InputStream is = null;
        try {
            is = this.currentAttachment.getAttachment().getInputStream();
        }
        catch (NotesException notesException) {
            // empty catch block
        }
        return is;
    }

    public int getAttachmentFilesize() {
        return this.currentAttachment.getFileSize();
    }

    private String getAbbreviatedName(String canonicalName) {
        Pattern ldapPattern = Pattern.compile("CN=.*?/(?:.*/)O=\\w*");
        Matcher m = ldapPattern.matcher(canonicalName);
        String abbrevName = canonicalName;
        if (m.lookingAt()) {
            boolean abbreviatedFailed = false;
            if (this.session != null) {
                try {
                    Name newName = this.session.createName(abbrevName);
                    abbrevName = newName.getAbbreviated();
                }
                catch (NotesException e) {
                    abbreviatedFailed = true;
                }
            }
            if (this.session == null || abbreviatedFailed) {
                String layer;
                String newID = "";
                String[] layers = abbrevName.split("/");
                int index = -1;
                String[] arr$ = layers;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (index = (layer = arr$[i$]).indexOf(61)) >= 0; ++i$) {
                    newID = newID.length() > 0 ? newID + "/" + layer.substring(index + 1) : layer.substring(index + 1);
                }
                if (index >= 0) {
                    abbrevName = newID;
                }
            }
        }
        return abbrevName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void parseFields() {
        try {
            this.fields.put("$DocUNID", this.origDocument.getUniversalID());
            this.fields.put("messagesize", Integer.toString(this.origDocument.getSize()));
            this.fields.put("ReplicaId", this.origDocument.getParentDatabase().getReplicaID());
            this.fields.put("noteUrl", this.origDocument.getNotesURL());
            try {
                this.fields.put("createdtime", Long.toString(this.origDocument.getCreated().toJavaDate().getTime()));
                this.fields.put("createdtimeTimeZone", "GMT+0");
            }
            catch (NotesException e) {
                // empty catch block
            }
            try {
                this.fields.put("lastmodified", Long.toString(this.origDocument.getLastModified().toJavaDate().getTime()));
            }
            catch (NotesException e) {
                // empty catch block
            }
            Vector items = this.origDocument.getItems();
            block38: for (Item item : items) {
                String name = item.getName();
                String value = "";
                switch (item.getType()) {
                    case 1: {
                        value = item.getText();
                        break;
                    }
                    case 21: 
                    case 1074: 
                    case 1075: 
                    case 1076: 
                    case 1280: {
                        Vector values = item.getValues();
                        if (values == null) break;
                        Iterator valueIter = values.iterator();
                        boolean isLdapField = name.equalsIgnoreCase("BlindCopyTo") || name.equalsIgnoreCase("CopyTo") || name.equalsIgnoreCase("From") || name.equalsIgnoreCase("SendTo") || name.equalsIgnoreCase("Principal");
                        boolean isEmailField = name.equalsIgnoreCase("InetBlindCopyTo") || name.equalsIgnoreCase("InetCopyTo") || name.equalsIgnoreCase("INetFrom") || name.equalsIgnoreCase("InetSendTo") || name.equalsIgnoreCase("InetPrincipal");
                        String actualValue = "";
                        Vector nameValues = null;
                        Iterator nameValueIter = null;
                        if (isEmailField) {
                            String nameField = name.substring("Inet".length());
                            nameValues = this.origDocument.getItemValue(nameField);
                            nameValueIter = nameValues.iterator();
                        }
                        while (valueIter.hasNext()) {
                            String actualSubValue;
                            String subValue = (String)valueIter.next();
                            value = value.length() > 0 ? value + ", " + subValue : subValue;
                            if (isLdapField) {
                                actualSubValue = this.getAbbreviatedName(subValue);
                                if (actualValue.length() > 0) {
                                    actualValue = actualValue + ", " + actualSubValue;
                                    continue;
                                }
                                actualValue = actualSubValue;
                                continue;
                            }
                            if (!isEmailField) continue;
                            actualSubValue = subValue;
                            if (nameValueIter.hasNext()) {
                                String nameSubValue = (String)nameValueIter.next();
                                if (".".equals(subValue)) {
                                    actualSubValue = nameSubValue = this.getAbbreviatedName(nameSubValue);
                                }
                            }
                            if (actualValue.length() > 0) {
                                actualValue = actualValue + ", " + actualSubValue;
                                continue;
                            }
                            actualValue = actualSubValue;
                        }
                        if (!isLdapField && !isEmailField) break;
                        this.fields.put("$$Real" + name, value);
                        value = actualValue;
                        break;
                    }
                    case 1024: {
                        DateTime time = item.getDateTimeValue();
                        int offset = time.getTimeZone();
                        boolean dst = time.isDST();
                        if (dst) {
                            --offset;
                        }
                        value = Long.toString(time.toJavaDate().getTime());
                        this.fields.put(name + "TimeZone", "GMT" + (offset <= 0 ? "+" : "") + -offset);
                        try {
                            time.recycle();
                        }
                        catch (NotesException ee) {}
                        break;
                        catch (NotesException e) {
                            try {
                                time.recycle();
                            }
                            catch (NotesException ee) {}
                            continue block38;
                            catch (Throwable throwable) {
                                try {
                                    time.recycle();
                                }
                                catch (NotesException ee) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                        }
                    }
                    case 768: {
                        int number = item.getValueInteger();
                        value = Integer.toString(number);
                        break;
                    }
                    case 1084: {
                        EmbeddedObject attachment;
                        String filename = item.getValueString();
                        if (filename == null || (attachment = this.origDocument.getAttachment(filename)) == null || attachment.getType() != 1454) break;
                        this.addAttachment(attachment, item.getLastModified());
                        break;
                    }
                    case 1282: {
                        Vector values;
                        if ("PostedDate".equalsIgnoreCase(name) && (values = item.getValues()) != null) {
                            try {
                                DateTime time = (DateTime)values.get(0);
                                int offset = time.getTimeZone();
                                boolean dst = time.isDST();
                                if (dst) {
                                    --offset;
                                }
                                value = Long.toString(time.toJavaDate().getTime());
                                this.fields.put(name + "TimeZone", "GMT" + (offset <= 0 ? "+" : "") + -offset);
                                try {
                                    time.recycle();
                                }
                                catch (NotesException ee) {}
                                break;
                                catch (NotesException e) {
                                    try {
                                        time.recycle();
                                    }
                                    catch (NotesException ee) {}
                                    continue block38;
                                    catch (Throwable throwable) {
                                        try {
                                            time.recycle();
                                        }
                                        catch (NotesException ee) {
                                            // empty catch block
                                        }
                                        throw throwable;
                                    }
                                }
                            }
                            catch (ClassCastException cce) {
                                // empty catch block
                            }
                        }
                        value = item.getText();
                        break;
                    }
                    default: {
                        value = item.getText();
                    }
                }
                if (value != null && value.length() > 0) {
                    if (name.equalsIgnoreCase("Body")) {
                        this.content = value;
                    } else {
                        this.fields.put(name, value);
                    }
                }
                try {
                    item.recycle();
                }
                catch (NotesException ee) {}
            }
            this.fields.put("hasattach", this.getAttachmentCount() > 0 ? "Y" : "N");
        }
        catch (NotesException notesException) {
            // empty catch block
        }
    }

    private void addAttachment(EmbeddedObject obj, DateTime datetime) {
        Date date = new Date();
        int zone = 0;
        String timezone = "GMT+0";
        if (datetime == null) {
            try {
                if (this.origDocument != null) {
                    datetime = this.origDocument.getLastModified();
                }
            }
            catch (NotesException e) {
                // empty catch block
            }
        }
        if (datetime != null) {
            try {
                date = datetime.toJavaDate();
                zone = datetime.getTimeZone();
                if (datetime.isDST()) {
                    --zone;
                }
                timezone = "GMT" + (zone <= 0 ? "+" : "") + zone;
            }
            catch (NotesException e) {
                // empty catch block
            }
        }
        Attachment attach = new Attachment(obj, date, timezone);
        this.attachmentList.add(attach);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        if (this.attachmentList != null) {
            for (int i = 0; i < this.attachmentList.size(); ++i) {
                try {
                    EmbeddedObject obj = this.attachmentList.get(i).getAttachment();
                    obj.recycle();
                    continue;
                }
                catch (NotesException notesException) {
                    // empty catch block
                }
            }
            this.attachmentList = null;
        }
        try {
            if (this.origDocument != null) {
                this.origDocument.recycle();
            }
        }
        catch (NotesException notesException) {
        }
        finally {
            this.origDocument = null;
        }
    }

    public class Attachment {
        EmbeddedObject attachment = null;
        Date date = null;
        String timeZone = null;

        public Attachment(EmbeddedObject attachment, Date date, String timezone) {
            this.attachment = attachment;
            this.date = date != null ? new Date(date.getTime()) : new Date();
            this.timeZone = timezone;
        }

        public EmbeddedObject getAttachment() {
            return this.attachment;
        }

        public Date getDate() {
            return new Date(this.date.getTime());
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public String getName() {
            String name = null;
            try {
                name = this.attachment.getSource();
            }
            catch (NotesException notesException) {
                // empty catch block
            }
            return name;
        }

        public int getFileSize() {
            int size = 0;
            try {
                size = this.attachment.getFileSize();
            }
            catch (NotesException notesException) {
                // empty catch block
            }
            return size;
        }
    }
}

