/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.dataio.server;

import com.ibm.es.nuvo.dataio.server.NotesAccessor;
import com.ibm.es.nuvo.dataio.server.NotesAccessorException;
import com.ibm.es.nuvo.dataio.server.NotesExporter;
import com.ibm.es.nuvo.dataio.util.fenced.DataReceiver;
import com.ibm.es.nuvo.dataio.util.fenced.MessageBlock;
import com.ibm.es.nuvo.dataio.util.fenced.MessageHandler;
import com.ibm.es.nuvo.dataio.util.fenced.ProcessConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class NotesDataReceiver
implements DataReceiver,
ProcessConstants {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private MessageHandler msgHandler;

    public NotesDataReceiver(MessageHandler handler) {
        this.msgHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exporting(OutputStream dos, String[] uris, String outFile, boolean append) {
        NotesExporter exporter = new NotesExporter();
        try {
            NotesDataReceiver.debugLog("OutputFilename:", outFile);
            NotesDataReceiver.debugLog("uris:");
            for (int i = 0; i < uris.length; ++i) {
                NotesDataReceiver.debugLog("\t", uris[i]);
            }
            exporter = new NotesExporter();
            if (uris.length > 0) {
                int docsExported = 0;
                String uri = uris[0];
                NotesDataReceiver.debugLog("uri:", uri);
                uri = uri.substring(uri.indexOf("://") + 3);
                NotesDataReceiver.debugLog("uri:", uri);
                uri = uri.substring(uri.indexOf("/") + 1);
                NotesDataReceiver.debugLog("uri:", uri);
                int index = uri.indexOf("?");
                if (index > 0) {
                    uri = uri.substring(0, index);
                }
                NotesDataReceiver.debugLog("uri:", uri);
                Properties config = System.getProperties();
                String templateFileName = uri;
                if (config.get("file.separator").equals("\\")) {
                    templateFileName = uri.replace('/', '\\');
                }
                NotesDataReceiver.debugLog("template:", templateFileName);
                NotesDataReceiver.debugLog("pre connect");
                if (exporter.connect(outFile, templateFileName, append)) {
                    docsExported = exporter.exportURIs(uris);
                    NotesDataReceiver.debugLog("exported ", Integer.toString(docsExported), "docs");
                    exporter.disconnect();
                } else {
                    NotesDataReceiver.debugLog("connect failed");
                    this.sendFailBlock(dos, 2);
                    return;
                }
            }
            MessageBlock msg = new MessageBlock();
            msg.setMessageType(2);
            msg.setCommand(2);
            msg.setResult(0);
            msg.setNumOfDocuments(1);
            msg.setSender(65283);
            msg.setReceiver(65284);
            byte[] blk = msg.createHeaderBlock();
            NotesDataReceiver.debugLog("before_header");
            NotesDataReceiver.debugLog(blk);
            dos.write(blk, 0, blk.length);
            dos.flush();
            blk = MessageBlock.createIntBlk(0);
            NotesDataReceiver.debugLog("before_sub_header");
            NotesDataReceiver.debugLog(blk);
            dos.write(blk, 0, blk.length);
            dos.flush();
            blk = MessageBlock.createIntBlk(0);
            dos.write(blk, 0, blk.length);
            dos.flush();
            blk = MessageBlock.createIntBlk(0);
            dos.write(blk, 0, blk.length);
            dos.flush();
            blk = MessageBlock.createIntBlk(0);
            NotesDataReceiver.debugLog("before_attachment");
            NotesDataReceiver.debugLog(blk);
            dos.write(blk, 0, blk.length);
            dos.flush();
        }
        catch (Throwable t) {
            NotesDataReceiver.debugLog("Throwable in NotesDataReciever:", t.getMessage());
        }
        finally {
            if (exporter != null) {
                exporter.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ingesting(OutputStream dos, String inFile, Date baseDate, String userIdPath, String userPass) throws IOException {
        boolean startedDocumentItaration = false;
        NotesAccessor notesAccessor = new NotesAccessor();
        try {
            NotesDataReceiver.debugLog(inFile);
            notesAccessor = new NotesAccessor();
            try {
                if (notesAccessor.connect(inFile, baseDate, userIdPath, userPass) != 0) {
                    this.sendFailBlock(dos, 1);
                    return;
                }
            }
            catch (NotesAccessorException nae) {
                this.sendFailBlock(dos, 1, nae.getErrId(), nae);
                throw nae;
            }
            catch (Throwable e) {
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                this.sendFailBlock(dos, 1, writer.toString());
                throw e;
            }
            MessageBlock msg = new MessageBlock();
            msg.setMessageType(2);
            msg.setCommand(1);
            msg.setResult(0);
            msg.setNumOfDocuments(notesAccessor.getDocumentCount());
            msg.setSender(65281);
            msg.setReceiver(65282);
            byte[] blk = msg.createHeaderBlock();
            NotesDataReceiver.debugLog("before_header");
            NotesDataReceiver.debugLog(blk);
            dos.write(blk, 0, blk.length);
            while (notesAccessor.nextDocument(baseDate)) {
                startedDocumentItaration = true;
                MessageBlock subMsg = new MessageBlock();
                blk = MessageBlock.createIntBlk(0);
                NotesDataReceiver.debugLog("before_sub_header");
                NotesDataReceiver.debugLog(blk);
                dos.write(blk, 0, blk.length);
                Hashtable<String, String> attributes = notesAccessor.getDocumentFields();
                Set<Map.Entry<String, String>> attribSet = attributes.entrySet();
                for (Map.Entry<String, String> entry : attribSet) {
                    subMsg.add(entry.getKey(), entry.getValue());
                }
                NotesDataReceiver.debugLog("before_attributes1");
                blk = subMsg.createAttributeBlock();
                NotesDataReceiver.debugLog("before_attributes2");
                dos.write(blk, 0, blk.length);
                String contentStr = notesAccessor.getContent();
                byte[] content = contentStr.getBytes("UTF-8");
                blk = MessageBlock.createIntBlk(content.length);
                NotesDataReceiver.debugLog(blk);
                dos.write(blk, 0, blk.length);
                NotesDataReceiver.debugLog("before_content");
                NotesDataReceiver.debugLog("Content length:", Integer.toString(content.length));
                dos.write(content, 0, content.length);
                blk = MessageBlock.createIntBlk(notesAccessor.getAttachmentCount());
                NotesDataReceiver.debugLog("before_attachment");
                NotesDataReceiver.debugLog(blk);
                dos.write(blk, 0, blk.length);
                while (notesAccessor.hasMoreAttachments()) {
                    if (!notesAccessor.nextAttachment()) continue;
                    MessageBlock attachMsg = new MessageBlock();
                    Hashtable<String, String> attachAttrib = notesAccessor.getAttachmentMetadata();
                    Set<Map.Entry<String, String>> attachAttribSet = attachAttrib.entrySet();
                    for (Map.Entry<String, String> entry : attachAttribSet) {
                        attachMsg.add(entry.getKey(), entry.getValue());
                    }
                    NotesDataReceiver.debugLog("before_attributes1");
                    blk = attachMsg.createAttributeBlock();
                    NotesDataReceiver.debugLog("before_attributes2");
                    dos.write(blk, 0, blk.length);
                    blk = MessageBlock.createIntBlk(notesAccessor.getAttachmentFilesize());
                    NotesDataReceiver.debugLog("before_attach_content_length");
                    NotesDataReceiver.debugLog(blk);
                    dos.write(blk, 0, blk.length);
                    InputStream is = notesAccessor.getAttachmentStream();
                    byte[] buffer = new byte[1024];
                    int byteCount = is.read(buffer);
                    while (byteCount != -1) {
                        dos.write(buffer, 0, byteCount);
                        byteCount = is.read(buffer);
                    }
                    is.close();
                }
                dos.flush();
            }
            dos.flush();
        }
        catch (Throwable t) {
            NotesDataReceiver.debugLog("Throwable in NotesDataReciever:", t.getMessage());
        }
        finally {
            if (notesAccessor != null) {
                notesAccessor.disconnect();
            }
            if (startedDocumentItaration) {
                this.sendEndBlock(dos);
            }
        }
    }

    private void sendEndBlock(OutputStream dos) throws IOException {
        byte[] blk = MessageBlock.createIntBlk(2);
        NotesDataReceiver.debugLog("sending end block");
        dos.write(blk, 0, blk.length);
        dos.flush();
    }

    private void sendFailBlock(OutputStream dos, int command, int errorId, Throwable e) throws IOException {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        this.sendFailBlock(dos, command, errorId, sw.toString());
    }

    private void sendFailBlock(OutputStream dos, int command) throws IOException {
        this.sendFailBlock(dos, command, 1000, "");
    }

    private void sendFailBlock(OutputStream dos, int command, String message) throws IOException {
        this.sendFailBlock(dos, command, 1000, message);
    }

    private void sendFailBlock(OutputStream dos, int command, int errorId, String ... messages) throws IOException {
        MessageBlock msg = new MessageBlock();
        msg.setMessageType(2);
        msg.setCommand(command);
        msg.setResult(1);
        msg.setNumOfDocuments(1);
        msg.setSender(65281);
        msg.setReceiver(65282);
        byte[] blk = msg.createHeaderBlock();
        NotesDataReceiver.debugLog("before_header");
        NotesDataReceiver.debugLog(blk);
        dos.write(blk, 0, blk.length);
        blk = MessageBlock.createIntBlk(1);
        NotesDataReceiver.debugLog("before_error_sub_header");
        NotesDataReceiver.debugLog(blk);
        dos.write(blk, 0, blk.length);
        blk = MessageBlock.createIntBlk(errorId);
        NotesDataReceiver.debugLog("before_error_code");
        NotesDataReceiver.debugLog(blk);
        dos.write(blk, 0, blk.length);
        blk = MessageBlock.createIntBlk(messages.length);
        dos.write(blk, 0, blk.length);
        for (String message : messages) {
            if (message == null || message.length() == 0) {
                blk = MessageBlock.createIntBlk(0);
                dos.write(blk, 0, blk.length);
                continue;
            }
            byte[] content = message.getBytes("UTF-8");
            blk = MessageBlock.createIntBlk(content.length);
            NotesDataReceiver.debugLog("before_error_msglen");
            NotesDataReceiver.debugLog(message);
            NotesDataReceiver.debugLog(blk);
            dos.write(blk, 0, blk.length);
            if (content.length <= 0) continue;
            dos.write(content, 0, content.length);
        }
        dos.flush();
    }

    private static void debugLog(byte[] msg) {
    }

    private static void debugLog(String ... msgList) {
    }

    private static void debugLog(String msg) {
    }
}

