/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.dataio.server;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.dataio.server.NotesAccessorException;
import com.ibm.es.nuvo.dataio.server.NotesDocument;
import com.ibm.es.nuvo.dataio.util.fenced.ProcessConstants;
import com.ibm.es.nuvo.util.Encryption;
import com.ibm.supa.notes.NotesConfigManager;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import lotus.domino.Database;
import lotus.domino.Document;
import lotus.domino.DocumentCollection;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.NotesThread;
import lotus.domino.Registration;
import lotus.domino.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotesAccessor
implements ProcessConstants {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    Session session = null;
    Database database = null;
    NotesDocument document = null;
    DocumentCollection allDocs = null;
    String dbPath = "";
    private boolean isNotesThreadInitialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleAllDocs() {
        try {
            if (this.allDocs != null) {
                this.allDocs.recycle();
            }
        }
        catch (NotesException notesException) {
        }
        finally {
            this.allDocs = null;
        }
    }

    private void recycleDocument() {
        if (this.document != null) {
            this.document.recycle();
            this.document = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleDatabase() {
        try {
            if (this.database != null) {
                this.database.recycle();
            }
        }
        catch (NotesException notesException) {
        }
        finally {
            this.database = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleSession() {
        try {
            if (this.session != null) {
                this.session.recycle();
            }
        }
        catch (NotesException notesException) {
        }
        finally {
            this.session = null;
        }
    }

    public void recycleAll() {
        this.recycleDocument();
        this.recycleAllDocs();
        this.recycleDatabase();
        this.recycleSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int connect(String databasePath, Date baseDate, String userIdPath, String userPass) throws NotesAccessorException {
        Class<?> clazz;
        Class<?> clazz2 = this.getClass();
        synchronized (clazz2) {
            NotesThread.sinitThread();
            this.isNotesThreadInitialized = true;
        }
        int errorCode = 0;
        String errorString = "No error";
        try {
            clazz = this.getClass();
            synchronized (clazz) {
                this.session = NotesFactory.createSession();
                if (userIdPath != null && userPass != null) {
                    Registration notesReg = this.session.createRegistration();
                    try {
                        userPass = Encryption.decrypt(userPass, NotesConfigManager.secKey);
                    }
                    catch (ExtendedException e1) {
                        userPass = null;
                    }
                    notesReg.switchToID(userIdPath, userPass);
                }
            }
            if (this.session != null) {
                this.database = this.session.getDatabase(null, databasePath, false);
                if (this.database != null) {
                    this.allDocs = baseDate == null ? this.database.getAllDocuments() : this.database.getModifiedDocuments(this.session.createDateTime(baseDate));
                    this.dbPath = databasePath;
                    if (this.allDocs != null && this.allDocs.getCount() > 0) {
                        return 0;
                    }
                    errorCode = 1065;
                    errorString = "No documents in DB";
                } else {
                    errorCode = 1062;
                    errorString = "Cannot access DB";
                }
            } else {
                errorCode = 1060;
                errorString = "Cannot connect to DB";
            }
        }
        catch (NotesException e) {
            e.printStackTrace();
            this.recycleAll();
            Class<?> notesReg = this.getClass();
            synchronized (notesReg) {
                NotesThread.stermThread();
                this.isNotesThreadInitialized = false;
            }
            NotesAccessorException nae = new NotesAccessorException(1060, (Throwable)e);
            throw nae;
        }
        this.recycleAll();
        clazz = this.getClass();
        synchronized (clazz) {
            NotesThread.stermThread();
            this.isNotesThreadInitialized = false;
        }
        throw new NotesAccessorException(errorCode, errorString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this.isNotesThreadInitialized) {
            this.recycleAll();
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                NotesThread.stermThread();
                this.isNotesThreadInitialized = false;
            }
            this.dbPath = null;
        }
    }

    public int getDocumentCount() {
        int count = 0;
        if (this.allDocs != null) {
            try {
                count = this.allDocs.getCount();
            }
            catch (NotesException notesException) {
                // empty catch block
            }
        }
        return count;
    }

    public String getContent() {
        return this.document.getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextDocument(Date baseDate) {
        if (this.allDocs == null) {
            if (this.database == null) {
                return false;
            }
            try {
                this.allDocs = baseDate == null ? this.database.getAllDocuments() : this.database.getModifiedDocuments(this.session.createDateTime(baseDate));
                if (this.allDocs != null) {
                    Document notesDoc = this.allDocs.getFirstDocument();
                    if (notesDoc != null) {
                        this.document = this.validateDocAndSkipIfNecessary(notesDoc);
                        if (this.document == null) {
                            this.recycleAllDocs();
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            }
            catch (NotesException e) {
                this.recycleAllDocs();
                return false;
            }
        }
        if (this.allDocs != null) {
            Document newDoc = null;
            if (this.document == null) {
                try {
                    Document notesDoc = this.allDocs.getFirstDocument();
                    if (notesDoc != null) {
                        this.document = this.validateDocAndSkipIfNecessary(notesDoc);
                        if (this.document == null) {
                            this.recycleAllDocs();
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                catch (NotesException e) {
                    this.recycleAllDocs();
                    return false;
                }
            }
            try {
                newDoc = this.allDocs.getNextDocument(this.document.getDocument());
            }
            catch (NotesException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.recycleDocument();
            }
            if (newDoc != null) {
                this.document = this.validateDocAndSkipIfNecessary(newDoc);
                if (this.document == null) {
                    this.recycleAllDocs();
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private NotesDocument validateDocAndSkipIfNecessary(Document doc) {
        if (this.allDocs == null) {
            return null;
        }
        NotesDocument tempDoc = null;
        try {
            tempDoc = new NotesDocument(doc, this.session);
        }
        catch (Throwable e) {
            try {
                Document nextDoc = this.allDocs.getNextDocument(doc);
                if (nextDoc == null) {
                    return null;
                }
                return this.validateDocAndSkipIfNecessary(nextDoc);
            }
            catch (NotesException e1) {
                return null;
            }
        }
        return tempDoc;
    }

    public boolean nextAttachment() {
        return this.document.nextAttachment();
    }

    public int getAttachmentCount() {
        return this.document.getAttachmentCount();
    }

    public boolean hasMoreAttachments() {
        return this.document.hasMoreAttachments();
    }

    public InputStream getAttachmentStream() {
        return this.document.getAttachmentStream();
    }

    public Hashtable<String, String> getAttachmentMetadata() {
        return this.document.getAttachmentMetadata();
    }

    public int getAttachmentFilesize() {
        return this.document.getAttachmentFilesize();
    }

    public Hashtable<String, String> getDocumentFields() {
        return this.document.getFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void debugLog(String msg) {
        PrintWriter pw = null;
        try {
            String debugFile = "notesAccessor.log";
            pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(debugFile, true)));
            pw.println(msg);
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Throwable e) {}
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("NotesAccessor <input nsf>");
            System.exit(0);
            return;
        }
        String dbName = args[0];
        NotesAccessor notesAccessor = new NotesAccessor();
        try {
            if (notesAccessor.connect(dbName, null, null, null) != 0) {
                notesAccessor.disconnect();
                System.err.println("Could not connect to db " + dbName);
                System.exit(0);
            }
        }
        catch (NotesAccessorException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Number of documents: " + notesAccessor.getDocumentCount());
        while (notesAccessor.nextDocument(null)) {
            System.out.print("Document 1: ");
            System.out.println("Document Fields: " + notesAccessor.getDocumentFields().size());
            Hashtable<String, String> fields = notesAccessor.getDocumentFields();
            for (Map.Entry<String, String> entry : fields.entrySet()) {
                System.out.print("Field: ");
                System.out.print(entry.getKey());
                System.out.print(": ");
                System.out.println(entry.getValue());
            }
            System.out.println("Attachments: " + notesAccessor.getAttachmentCount());
            while (notesAccessor.nextAttachment()) {
                System.out.println("Attachment filename: " + notesAccessor.getAttachmentMetadata().get("filename"));
            }
            System.out.println("Content:" + notesAccessor.getContent());
        }
        notesAccessor.disconnect();
        System.exit(0);
    }
}

