/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.dataio.ingest;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.dataio.DataIOType;
import com.ibm.es.nuvo.dataio.handler.nsf.NSFHandler;
import com.ibm.es.nuvo.dataio.handler.pst.PSTHandler;
import com.ibm.es.nuvo.dataio.ingest.IngestException;
import com.ibm.es.nuvo.dataio.ingest.IngestHandler;
import com.ibm.es.nuvo.dataio.ingest.IngestResult;
import com.ibm.es.nuvo.documentqueue.BaseDocument;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class IngestManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static Boolean ingestionSupported;
    private static IngestManager instance;
    boolean isWindows;
    private HashMap<DataIOType.ExtType, ArrayList<IngestHandler>> allHandlers = new HashMap();
    private HashMap<DataIOType.ExtType, ArrayList<IngestHandler>> waitingHandlers = new HashMap();
    private HashMap<DataIOType.ExtType, ArrayList<IngestHandler>> runningHandlers = new HashMap();

    public static synchronized IngestManager instance() throws IngestException {
        if (instance == null) {
            instance = new IngestManager();
            instance.getIngestHandler(DataIOType.ExtType.PST);
            instance.getIngestHandler(DataIOType.ExtType.NSF);
            IngestManager.instance.isWindows = GlobalConfiguration.getConfiguration().isWindows();
        }
        return instance;
    }

    public static final synchronized boolean isIngestionSupported() {
        if (ingestionSupported == null) {
            ReleaseInfo info = ReleaseInfo.getReleaseInfo();
            try {
                ingestionSupported = info != null ? info.getValueAsBoolean("System", "IngestionSupported", true) : true;
            }
            catch (ExtendedException e) {
                ingestionSupported = true;
            }
        }
        return ingestionSupported;
    }

    public static synchronized void setIngestionSupported(boolean flag) {
        ingestionSupported = flag;
    }

    private IngestManager() {
        ArrayList list = new ArrayList();
        this.allHandlers.put(DataIOType.ExtType.PST, list);
        list = new ArrayList();
        this.allHandlers.put(DataIOType.ExtType.NSF, list);
        list = new ArrayList();
        this.waitingHandlers.put(DataIOType.ExtType.PST, list);
        list = new ArrayList();
        this.waitingHandlers.put(DataIOType.ExtType.NSF, list);
        list = new ArrayList();
        this.runningHandlers.put(DataIOType.ExtType.PST, list);
        list = new ArrayList();
        this.runningHandlers.put(DataIOType.ExtType.NSF, list);
    }

    protected synchronized IngestHandler getIngestHandler(DataIOType.ExtType type) throws IngestException {
        IngestHandler handler = null;
        ArrayList<IngestHandler> wList = this.waitingHandlers.get((Object)type);
        if (wList.isEmpty()) {
            if (type == DataIOType.ExtType.PST) {
                handler = new PSTHandler(this);
            } else if (type == DataIOType.ExtType.NSF) {
                handler = new NSFHandler(this);
            }
            ArrayList<IngestHandler> aList = this.allHandlers.get((Object)type);
            aList.add(handler);
        } else {
            handler = wList.remove(0);
        }
        ArrayList<IngestHandler> rList = this.runningHandlers.get((Object)type);
        rList.add(handler);
        return handler;
    }

    public IngestResult execute(String uri, Date baseDate, String userIdPath, String userPass) throws IngestException {
        try {
            if (DataIOType.isExtPST(uri) && this.isWindows) {
                IngestHandler handler = instance.getIngestHandler(DataIOType.ExtType.PST);
                return handler.execute(uri, baseDate, userIdPath, userPass);
            }
            if (DataIOType.isExtNSF(uri)) {
                IngestHandler handler = instance.getIngestHandler(DataIOType.ExtType.NSF);
                return handler.execute(uri, baseDate, userIdPath, userPass);
            }
            return null;
        }
        catch (Throwable t) {
            throw IngestException.handleUnknownException(uri, t);
        }
    }

    public IngestResult execute(BaseDocument baseDoc, Date baseDate, String userIdPath, String userPass) throws IngestException {
        if (!IngestManager.isIngestionSupported()) {
            return null;
        }
        try {
            String uri = baseDoc.getUri();
            if (DataIOType.isExtPST(uri) && this.isWindows) {
                IngestHandler handler = instance.getIngestHandler(DataIOType.ExtType.PST);
                return handler.execute(baseDoc, baseDate, userIdPath, userPass);
            }
            if (DataIOType.isExtNSF(uri)) {
                IngestHandler handler = instance.getIngestHandler(DataIOType.ExtType.NSF);
                return handler.execute(baseDoc, baseDate, userIdPath, userPass);
            }
            return null;
        }
        catch (Throwable t) {
            throw IngestException.handleUnknownException(baseDoc.getUri(), t);
        }
    }

    public synchronized void release(IngestHandler handler) {
        DataIOType.ExtType type = DataIOType.ExtType.NONE;
        type = handler instanceof PSTHandler ? DataIOType.ExtType.PST : DataIOType.ExtType.NSF;
        ArrayList<IngestHandler> rlist = this.runningHandlers.get((Object)type);
        ArrayList<IngestHandler> wlist = this.waitingHandlers.get((Object)type);
        if (!rlist.contains(handler)) {
            throw new RuntimeException("Invalied Status");
        }
        rlist.remove(handler);
        wlist.add(handler);
    }

    public synchronized void shutdown() {
        for (IngestHandler handler : this.allHandlers.get((Object)DataIOType.ExtType.PST)) {
            handler.term();
        }
        for (IngestHandler handler : this.allHandlers.get((Object)DataIOType.ExtType.NSF)) {
            handler.term();
        }
    }

    static {
        instance = null;
    }
}

