/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.dataio.handler.pst;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.dataio.handler.FencedResult;
import com.ibm.es.nuvo.dataio.ingest.IngestHandler;
import com.ibm.es.nuvo.dataio.ingest.IngestPredefinedMetaName;
import java.util.HashMap;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSTResult
extends FencedResult
implements IngestPredefinedMetaName {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    static final String PROPERTY_NAME_ENTRYID = "PR_ENTRYID";
    static final String PROPERTY_NAME_ATTACHNAME = "PR_ATTACH_LONG_FILENAME";
    static final String INITIAL_DOCUMENT_DATE_PROPERTY = "PR_MESSAGE_DELIVERY_TIME";
    static final String SECONDARY_DOCUMENT_DATE_PROPERTY = "PR_LAST_MODIFICATION_TIME";
    private static HashMap<String, String> simpleMetadataField = new HashMap();
    private static HashMap<String, String> dateMetadataField;
    private static HashMap<String, String[]> addressMetadataField;

    public PSTResult(IngestHandler handler) {
        super(handler);
    }

    @Override
    protected boolean isMsgId(String key) {
        return key.equalsIgnoreCase(PROPERTY_NAME_ENTRYID);
    }

    @Override
    protected String getMetadata(HashMap<String, String> fields, Metadata metadata, boolean isContent) {
        String msgId;
        Metadata.Type type = Metadata.Type.CrawlerImplicit;
        for (String key : fields.keySet()) {
            if (key == null || key == null || key.length() == 0) continue;
            String value = fields.get(key);
            String mappedKey = simpleMetadataField.get(key);
            if (mappedKey != null) {
                metadata.add(type, mappedKey, value);
                continue;
            }
            mappedKey = dateMetadataField.get(key);
            if (mappedKey != null) {
                metadata.add(type, mappedKey, Long.parseLong(value) * 1000L);
                continue;
            }
            String[] mappedKeys = addressMetadataField.get(key);
            if (mappedKeys == null) continue;
            metadata.add(type, mappedKeys[0], value.replaceAll(";", ","));
            value = this.extractEmailAddress(value);
            metadata.add(type, mappedKeys[1], value);
        }
        if (isContent) {
            msgId = fields.get(PROPERTY_NAME_ENTRYID);
            String date = fields.get(INITIAL_DOCUMENT_DATE_PROPERTY);
            if (date == null) {
                date = fields.get(SECONDARY_DOCUMENT_DATE_PROPERTY);
            }
            this.setDateValue(Long.parseLong(date) * 1000L);
        } else {
            msgId = fields.get(PROPERTY_NAME_ATTACHNAME);
        }
        return msgId;
    }

    private String extractEmailAddress(String nameList) {
        StringBuilder resultList = new StringBuilder();
        StringTokenizer st = new StringTokenizer(nameList, ";");
        while (st.hasMoreTokens()) {
            String name = st.nextToken().trim();
            if (!name.contains("@")) continue;
            if (resultList.length() > 0) {
                resultList.append(", ");
            }
            resultList.append(name);
        }
        if (resultList.length() > 0) {
            return resultList.toString();
        }
        return null;
    }

    static {
        simpleMetadataField.put("PR_SENDER_NAME", "from");
        simpleMetadataField.put("PR_SENDER_EMAIL_ADDRESS", "fromemailaddress");
        simpleMetadataField.put("PR_RECEIVED_BY_NAME", "receivedby");
        simpleMetadataField.put("PR_RECEIVED_BY_EMAIL_ADDRESS", "receivedbyemailaddress");
        simpleMetadataField.put("PR_SUBJECT", "subject");
        simpleMetadataField.put("PR_IMPORTANCE", "importance");
        simpleMetadataField.put("PR_PRIORITY", "priority");
        simpleMetadataField.put("PR_SENSITIVITY", "sensitivity");
        simpleMetadataField.put("PR_MESSAGE_SIZE", "messagesize");
        simpleMetadataField.put("PR_HASATTACH", "hasattach");
        simpleMetadataField.put("PR_OBJECT_TYPE", "objecttype");
        simpleMetadataField.put("PR_CONVERSATION_TOPIC", "initialsubjectinthread");
        simpleMetadataField.put(PROPERTY_NAME_ATTACHNAME, "filename");
        simpleMetadataField.put("PR_ATTACH_SIZE", "contentsize");
        simpleMetadataField.put("PR_SENT_REPRESENTING_NAME", "sentrepresenting");
        simpleMetadataField.put("PR_SENT_REPRESENTING_EMAIL_ADDRESS", "sentrepresentingemailaddress");
        simpleMetadataField.put("PR_RCVD_REPRESENTING_NAME", "receivedrepresenting");
        simpleMetadataField.put("PR_RCVD_REPRESENTING_EMAIL_ADDRESS", "receivedrepresentingemailaddress");
        dateMetadataField = new HashMap();
        dateMetadataField.put("PR_CREATION_TIME", "createdtime");
        dateMetadataField.put("PR_CLIENT_SUBMIT_TIME", "postedtime");
        dateMetadataField.put(INITIAL_DOCUMENT_DATE_PROPERTY, "deliveredtime");
        dateMetadataField.put(SECONDARY_DOCUMENT_DATE_PROPERTY, "lastmodifiedtime");
        addressMetadataField = new HashMap();
        addressMetadataField.put("PR_DISPLAY_TO", new String[]{"to", "toemailaddress"});
        addressMetadataField.put("PR_DISPLAY_CC", new String[]{"cc", "ccemailaddress"});
        addressMetadataField.put("PR_DISPLAY_BCC", new String[]{"bcc", "bccemailaddress"});
    }
}

