/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.dataio.handler.pst;

import com.ibm.es.nuvo.dataio.DataIOType;
import com.ibm.es.nuvo.dataio.handler.FencedHandler;
import com.ibm.es.nuvo.dataio.handler.pst.PSTResult;
import com.ibm.es.nuvo.dataio.ingest.IngestException;
import com.ibm.es.nuvo.dataio.ingest.IngestManager;
import com.ibm.es.nuvo.dataio.ingest.IngestResult;
import com.ibm.es.nuvo.dataio.util.fenced.FencedProcessException;
import com.ibm.es.nuvo.documentqueue.BaseDocument;
import java.util.Date;

public class PSTHandler
extends FencedHandler {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public PSTHandler() {
    }

    public PSTHandler(IngestManager manager) {
        super(manager);
    }

    public IngestResult execute(String uri, Date baseDate, String userIdPath, String userPass) throws IngestException {
        try {
            this.prepareFencedProcess(null);
            this.fencedProcess.ingestFile(uri, baseDate, userIdPath, userPass);
            PSTResult result = new PSTResult(this);
            result.setFencedProcess(this.fencedProcess);
            result.setOriginalURI(uri);
            return result;
        }
        catch (FencedProcessException e) {
            throw new IngestException(uri, (Throwable)e);
        }
    }

    public IngestResult execute(BaseDocument document, Date baseDate, String userIdPath, String userPass) throws IngestException {
        try {
            this.prepareFencedProcess(document);
            String uri = document.getUri();
            if (this.isPushAPI()) {
                uri = this.getNewURI();
            }
            this.fencedProcess.ingestFile(uri, baseDate, userIdPath, userPass);
            PSTResult result = new PSTResult(this);
            result.setFencedProcess(this.fencedProcess);
            result.setOriginalURI(uri);
            result.setOriginalCrawlSpaceId(this.getCrawlSpaceId(document));
            return result;
        }
        catch (FencedProcessException e) {
            throw new IngestException(document.getUri(), (Throwable)e);
        }
    }

    protected DataIOType.ExtType getExtType() {
        return DataIOType.ExtType.PST;
    }
}

