/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.dataio.handler.nsf;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.dataio.handler.FencedResult;
import com.ibm.es.nuvo.dataio.ingest.IngestHandler;
import com.ibm.es.nuvo.dataio.ingest.IngestPredefinedMetaName;
import com.ibm.es.nuvo.dataio.server.NotesConstants;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSFResult
extends FencedResult
implements IngestPredefinedMetaName,
NotesConstants {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static MetadataMap predefinedMetaField = new MetadataMap();

    public NSFResult(IngestHandler handler) {
        super(handler);
    }

    @Override
    protected boolean isMsgId(String key) {
        return key.equalsIgnoreCase("$DocUNID");
    }

    @Override
    protected String getMetadata(HashMap<String, String> fields, Metadata metadata, boolean isContent) {
        Metadata.Type type = Metadata.Type.CrawlerImplicit;
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            String key = entry.getKey();
            if (key == null || key == null || key.length() == 0) continue;
            String value = entry.getValue();
            String[] mappedKeys = this.getKeyName(key);
            for (int i = 0; i < mappedKeys.length; ++i) {
                metadata.add(type, mappedKeys[i], value);
            }
        }
        String[] dateFields = new String[]{"deliveredtime", "postedtime", "docdate", "createdtime"};
        boolean dateSet = false;
        for (String key : dateFields) {
            String value = metadata.get(key);
            if (value == null || value.length() <= 0) continue;
            String tzValue = fields.get(key + "TimeZone");
            if (tzValue == null || tzValue.length() == 0) {
                tzValue = "PST";
            }
            try {
                this.setDateValue(Long.parseLong(value));
                this.setTimeZone(tzValue);
                dateSet = true;
                break;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (!dateSet) {
            this.setDateValue(System.currentTimeMillis());
            this.setTimeZone("PST");
        }
        String msgId = isContent ? fields.get("$DocUNID") : fields.get("filename");
        return msgId;
    }

    private String[] getKeyName(String key) {
        String mappedKey = predefinedMetaField.get(key);
        if (mappedKey != null) {
            return new String[]{mappedKey};
        }
        return new String[]{key};
    }

    static {
        predefinedMetaField.put("SendTo", "to");
        predefinedMetaField.put("InetSendTo", "toemailaddress");
        predefinedMetaField.put("CopyTo", "cc");
        predefinedMetaField.put("InetCopyTo", "ccemailaddress");
        predefinedMetaField.put("BlindCopyTo", "bcc");
        predefinedMetaField.put("InetBlindCopyTo", "bccemailaddress");
        predefinedMetaField.put("From", "from");
        predefinedMetaField.put("INetFrom", "fromemailaddress");
        predefinedMetaField.put("Subject", "subject");
        predefinedMetaField.put("$MessageID", "messageid");
        predefinedMetaField.put("In_Reply_To", "parentmessageid");
        predefinedMetaField.put("Importance", "importance");
        predefinedMetaField.put("DeliveryPriority", "priority");
        predefinedMetaField.put("Classification", "sensitivity");
        predefinedMetaField.put("messagesize", "messagesize");
        predefinedMetaField.put("hasattach", "hasattach");
        predefinedMetaField.put("Form", "objecttype");
        predefinedMetaField.put("createdtime", "createdtime");
        predefinedMetaField.put("PostedDate", "postedtime");
        predefinedMetaField.put("DeliveredDate", "deliveredtime");
        predefinedMetaField.put("lastmodified", "lastmodifiedtime");
        predefinedMetaField.put("Principal", "sentrepresenting");
        predefinedMetaField.put("InetPrincipal", "sentrepresentingemailaddress");
        predefinedMetaField.put("createdtimeTimeZone", "createdtimeTimeZone");
        predefinedMetaField.put("PostedDateTimeZone", "postedtimeTimeZone");
        predefinedMetaField.put("DeliveredDateTimeZone", "deliveredtimeTimeZone");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MetadataMap
    extends HashMap<String, String> {
        private static final long serialVersionUID = 1L;

        MetadataMap() {
        }

        @Override
        public boolean containsKey(Object key) {
            if (key instanceof String) {
                String strKey = (String)key;
                return super.containsKey(strKey.toLowerCase());
            }
            return false;
        }

        @Override
        public String get(Object key) {
            if (key instanceof String) {
                String strKey = (String)key;
                return (String)super.get(strKey.toLowerCase());
            }
            return null;
        }

        @Override
        public String put(String key, String value) {
            return super.put(key.toLowerCase(), value);
        }

        @Override
        public String remove(Object key) {
            if (key instanceof String) {
                String strKey = (String)key;
                return (String)super.remove(strKey.toLowerCase());
            }
            return null;
        }
    }
}

