/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.dataio.handler;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.dataio.ingest.IngestException;
import com.ibm.es.nuvo.dataio.ingest.IngestHandler;
import com.ibm.es.nuvo.dataio.ingest.IngestResult;
import com.ibm.es.nuvo.dataio.util.fenced.MessageContent;
import com.ibm.es.nuvo.dataio.util.fenced.ProcessConstants;
import com.ibm.es.nuvo.dataio.util.fenced.msg.MessageFencedTask;
import com.ibm.es.nuvo.documentqueue.BaseDocument;
import com.ibm.es.nuvo.documentqueue.DataBufferStreamDocument;
import com.ibm.es.nuvo.documentqueue.DocumentImpl;
import com.ibm.es.nuvo.documentqueue.DocumentStreamCreateException;
import com.ibm.es.nuvo.util.databuffer.DataBufferOutputStream;
import java.io.IOException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FencedResult
implements IngestResult,
ProcessConstants {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String FIELD_DATE = "Date";
    private static final String FIELD_TZ = "timezone";
    private long dateValue;
    private String timeZone;
    protected static final String URL_ENCODING = "UTF-8";
    protected MessageFencedTask fencedProcess;
    protected IngestHandler ingestHandler;
    MessageContent currentContent;
    protected boolean isPushAPI;
    private String originalURI;
    private String originalCrawlSpaceId;

    public FencedResult(IngestHandler handler) {
        this.ingestHandler = handler;
        this.setPushAPI(false);
        this.setTimeZone(null);
    }

    @Override
    public void close() throws IngestException {
        this.ingestHandler.release();
    }

    @Override
    public boolean hasNext() throws IngestException {
        try {
            boolean hasNext;
            this.currentContent = null;
            MessageContent content = this.fencedProcess.getIngestResult(this.getOriginalURI());
            if (content == null) {
                hasNext = false;
            } else {
                hasNext = true;
                this.currentContent = content;
            }
            return hasNext;
        }
        catch (Throwable t) {
            throw IngestException.handleUnknownException(this.getOriginalURI(), t);
        }
    }

    @Override
    public BaseDocument nextDocument() throws IngestException {
        int attachmentMaxSize = 10000000;
        try {
            DataBufferStreamDocument document = this.generateContent(this.currentContent, true);
            for (MessageContent aMsgContent : this.currentContent.getAttachments()) {
                try {
                    if (aMsgContent.getBuffer().length >= 10000000) continue;
                    DataBufferStreamDocument attachment = this.generateContent(aMsgContent, false);
                    document.addPart(attachment);
                }
                catch (Throwable t) {}
            }
            return document;
        }
        catch (Throwable t) {
            throw IngestException.handleUnknownException(this.getOriginalURI(), t);
        }
    }

    @Override
    public DocumentImpl nextDocumentCache() throws IngestException {
        try {
            DataBufferStreamDocument document = this.generateContent(this.currentContent, true);
            for (MessageContent aMsgContent : this.currentContent.getAttachments()) {
                DataBufferStreamDocument attachment = this.generateContent(aMsgContent, false);
                document.addPart(attachment);
            }
            DocumentImpl documentImpl = new DocumentImpl(document.getUri(), document.getInputStream());
            documentImpl.setMetadata(document.getMetadata());
            return documentImpl;
        }
        catch (Throwable t) {
            throw IngestException.handleUnknownException(this.getOriginalURI(), t);
        }
    }

    @Override
    public IngestHandler getHandler() {
        return this.ingestHandler;
    }

    private DataBufferStreamDocument generateContent(MessageContent msgContent, boolean isContent) throws IngestException {
        String uri;
        HashMap<String, String> fields = msgContent.getFields();
        Metadata metadata = new Metadata();
        if (isContent) {
            String msgId;
            metadata.set("ContentType", "text/plain");
            uri = msgId = this.getMetadata(fields, metadata, isContent);
        } else {
            uri = this.getMetadata(fields, metadata, isContent);
        }
        DataBufferStreamDocument document = null;
        if (msgContent.getBuffer() != null) {
            try {
                DataBufferOutputStream dataBuffer = new DataBufferOutputStream();
                dataBuffer.write(msgContent.getBuffer());
                dataBuffer.close();
                document = new DataBufferStreamDocument(uri, dataBuffer);
            }
            catch (DocumentStreamCreateException e) {
                throw IngestException.handleUnknownException(this.getOriginalURI(), e);
            }
            catch (IOException e) {
                throw IngestException.handleUnknownException(this.getOriginalURI(), e);
            }
        }
        try {
            document = new DataBufferStreamDocument(uri, null);
        }
        catch (DocumentStreamCreateException e) {
            throw IngestException.handleUnknownException(this.getOriginalURI(), e);
        }
        metadata.set("CrawlSpaceID", this.getOriginalCrawlSpaceId());
        metadata.set(FIELD_DATE, Long.toString(this.getDateValue()));
        String tzstring = this.getTimeZone();
        if (tzstring != null) {
            metadata.set(FIELD_TZ, this.getTimeZone());
        }
        document.setMetadata(metadata);
        return document;
    }

    public void setFencedProcess(MessageFencedTask process) {
        this.fencedProcess = process;
    }

    protected abstract boolean isMsgId(String var1);

    protected abstract String getMetadata(HashMap<String, String> var1, Metadata var2, boolean var3);

    public String getOriginalURI() {
        return this.originalURI;
    }

    public void setOriginalURI(String ouri) {
        this.originalURI = ouri;
    }

    protected long getDateValue() {
        return this.dateValue;
    }

    protected void setDateValue(long dateValue) {
        this.dateValue = dateValue;
    }

    protected String getTimeZone() {
        return this.timeZone;
    }

    protected void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getOriginalCrawlSpaceId() {
        return this.originalCrawlSpaceId;
    }

    public void setOriginalCrawlSpaceId(String originalCrawlSpaceId) {
        this.originalCrawlSpaceId = originalCrawlSpaceId;
    }

    public boolean isPushAPI() {
        return this.isPushAPI;
    }

    public void setPushAPI(boolean isPushAPI) {
        this.isPushAPI = isPushAPI;
    }
}

