/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.dataio.handler;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.dataio.DataIOType;
import com.ibm.es.nuvo.dataio.export.ExportException;
import com.ibm.es.nuvo.dataio.export.ExportHandler;
import com.ibm.es.nuvo.dataio.export.ExportResult;
import com.ibm.es.nuvo.dataio.ingest.IngestException;
import com.ibm.es.nuvo.dataio.ingest.IngestHandler;
import com.ibm.es.nuvo.dataio.ingest.IngestManager;
import com.ibm.es.nuvo.dataio.util.fenced.FencedProcessException;
import com.ibm.es.nuvo.dataio.util.fenced.ProcessManager;
import com.ibm.es.nuvo.dataio.util.fenced.msg.MessageFencedTask;
import com.ibm.es.nuvo.documentqueue.BaseDocument;
import com.ibm.es.nuvo.documentqueue.DataBufferStreamDocument;
import com.ibm.es.nuvo.documentqueue.DocumentImpl;
import com.ibm.es.nuvo.documentqueue.FilenameDocument;
import com.ibm.es.nuvo.documentqueue.StreamedDocument;
import com.ibm.es.nuvo.util.uri.FSURIUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FencedHandler
implements IngestHandler,
ExportHandler {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected IngestManager ingestManager;
    protected MessageFencedTask fencedProcess;
    protected ProcessManager processManager = ProcessManager.getInstance();
    protected boolean isPushAPI;
    protected String newURI;

    public FencedHandler() {
    }

    public FencedHandler(IngestManager manager) {
        this.ingestManager = manager;
    }

    protected abstract DataIOType.ExtType getExtType();

    protected void prepareFencedProcess(BaseDocument document) throws FencedProcessException {
        if (document == null) {
            this.setPushAPI(false);
        } else if (document instanceof FilenameDocument || document instanceof DataBufferStreamDocument) {
            this.setPushAPI(false);
        } else {
            this.setPushAPI(true);
            try {
                File tmpFile = this.generateCachedFile(document, this.getExtType());
                String uri = FSURIUtil.getEncodedUri("localhost", tmpFile);
                this.setNewURI(uri);
            }
            catch (IngestException ie) {
                throw new FencedProcessException(ie);
            }
        }
        if (this.fencedProcess == null) {
            Class[] cArgs = new Class[]{DataIOType.ExtType.class};
            Object[] iArgs = new Object[]{this.getExtType()};
            this.fencedProcess = (MessageFencedTask)this.processManager.getProcesses(MessageFencedTask.class, cArgs, iArgs);
        }
    }

    @Override
    public ExportResult exportSubContents(List<String> uris, String filename, boolean append) throws ExportException {
        try {
            this.prepareFencedProcess(null);
            this.fencedProcess.exportFile(uris.toArray(new String[0]), filename, append);
            this.fencedProcess.getExportResult();
            return null;
        }
        catch (FencedProcessException e) {
            throw new ExportException(e);
        }
    }

    @Override
    public void release() {
        this.ingestManager.release(this);
        if (this.processManager != null && this.fencedProcess != null) {
            this.processManager.disposeProcess(this.fencedProcess);
        }
        this.term();
    }

    @Override
    public void term() {
        try {
            if (this.fencedProcess != null) {
                this.fencedProcess.terminate();
                this.fencedProcess = null;
            }
        }
        catch (FencedProcessException e) {
            e.printStackTrace();
        }
    }

    protected String getCrawlSpaceId(BaseDocument document) {
        String crawlSpaceId = "";
        if (document instanceof FilenameDocument) {
            Metadata metadata = ((FilenameDocument)document).getMetadata();
            crawlSpaceId = metadata.get("CrawlSpaceID");
        } else if (document instanceof StreamedDocument) {
            Metadata metadata = ((StreamedDocument)document).getMetadata();
            crawlSpaceId = metadata.get("CrawlSpaceID");
        }
        return crawlSpaceId;
    }

    public boolean isPushAPI() {
        return this.isPushAPI;
    }

    public void setPushAPI(boolean isPushAPI) {
        this.isPushAPI = isPushAPI;
    }

    private File generateCachedFile(BaseDocument doc, DataIOType.ExtType type) throws IngestException {
        DocumentImpl docimpl = (DocumentImpl)doc;
        String pathName = GlobalConfiguration.getConfiguration().getConfigPath() + File.separator + "export_cache";
        File dirName = new File(pathName);
        dirName.mkdir();
        File tmpFile = null;
        try {
            if (type == DataIOType.ExtType.PST) {
                tmpFile = File.createTempFile("~ing", ".pst", dirName);
            } else if (type == DataIOType.ExtType.NSF) {
                tmpFile = File.createTempFile("~ing", ".nsf", dirName);
            } else {
                throw new IngestException("", (Throwable)new RuntimeException("unsupported type"));
            }
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile));
            BufferedInputStream bis = new BufferedInputStream(docimpl.getInputStream());
            byte[] buf = new byte[8192];
            int read = bis.read(buf, 0, 8192);
            while (read > 0) {
                bos.write(buf, 0, read);
                read = bis.read(buf, 0, 8192);
            }
            bos.close();
            bis.close();
            return tmpFile;
        }
        catch (IOException ioe) {
            throw new IngestException("", (Throwable)ioe);
        }
    }

    public String getNewURI() {
        return this.newURI;
    }

    public void setNewURI(String newURI) {
        this.newURI = newURI;
    }
}

