/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.dataio.export;

import com.ibm.es.nuvo.dataio.DataIOType;
import com.ibm.es.nuvo.dataio.export.ExportException;
import com.ibm.es.nuvo.dataio.export.ExportHandler;
import com.ibm.es.nuvo.dataio.handler.nsf.NSFHandler;
import com.ibm.es.nuvo.dataio.handler.pst.PSTHandler;
import com.ibm.es.nuvo.util.uri.FSURIUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static ExportManager instance = null;
    private HashMap<DataIOType.ExtType, ExportHandler> handlers = new HashMap();

    public static synchronized ExportManager getInstance() throws ExportException {
        if (instance == null) {
            instance = new ExportManager();
        }
        return instance;
    }

    private ExportManager() {
    }

    public void exportSubContents(List<String> uris, String outFile, boolean append) throws ExportException {
        if (DataIOType.isExtPST(uris.get(0))) {
            ExportHandler handler = instance.getExportHandler(DataIOType.ExtType.PST);
            handler.exportSubContents(uris, outFile, append);
        } else if (DataIOType.isExtNSF(uris.get(0))) {
            ExportHandler handler = instance.getExportHandler(DataIOType.ExtType.NSF);
            handler.exportSubContents(uris, outFile, append);
        } else {
            return;
        }
    }

    public void deleteCachedFile(String uri) throws ExportException {
        int lastIndex = uri.lastIndexOf("?id=");
        String filename = null;
        if (lastIndex < 0) {
            throw new ExportException("C8202E.EXPORT_DELETE_ERR", uri);
        }
        filename = uri.substring(0, lastIndex);
        File file = FSURIUtil.getFileObject(filename);
        if (DataIOType.isExtPST(filename) || DataIOType.isExtNSF(filename)) {
            boolean rc = file.delete();
            if (!rc) {
                throw new ExportException("C8202E.EXPORT_DELETE_ERR", uri);
            }
        } else {
            throw new ExportException("C8202E.EXPORT_DELETE_ERR", uri);
        }
    }

    synchronized ExportHandler getExportHandler(DataIOType.ExtType type) {
        ExportHandler handler = this.handlers.get((Object)type);
        if (handler == null) {
            if (type == DataIOType.ExtType.PST) {
                handler = new PSTHandler();
            } else if (type == DataIOType.ExtType.NSF) {
                handler = new NSFHandler();
            }
            this.handlers.put(type, handler);
        }
        return handler;
    }

    public synchronized void shutdown() {
        for (ExportHandler handler : this.handlers.values()) {
            handler.term();
        }
    }
}

