/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.dataio;

public class DataIOType {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String EXT_PST = ".pst";
    public static final String EXT_NSF = ".nsf";

    public static ExtType checkType(String filename) {
        if (filename == null || filename.length() == 0) {
            return ExtType.NONE;
        }
        String lcFilename = filename.toLowerCase();
        int lclen = lcFilename.length();
        if (lcFilename.lastIndexOf(EXT_PST) == lclen - EXT_PST.length()) {
            return ExtType.PST;
        }
        if (lcFilename.lastIndexOf(EXT_NSF) == lclen - EXT_NSF.length()) {
            return ExtType.NSF;
        }
        return ExtType.NONE;
    }

    public static boolean isExtPST(String filename) {
        return DataIOType.checkType(filename) == ExtType.PST;
    }

    public static boolean isExtNSF(String filename) {
        return DataIOType.checkType(filename) == ExtType.NSF;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExtType {
        PST,
        NSF,
        NONE;

    }
}

