/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawlspace;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.CollectionCrawlspaceConfigurationManager;
import com.ibm.es.nuvo.crawlspace.CrawlspaceBranch;
import com.ibm.es.nuvo.crawlspace.HttpAuth;
import com.ibm.es.nuvo.crawlspace.HttpBasicAuth;
import com.ibm.es.nuvo.crawlspace.HttpFormAuth;
import com.ibm.es.nuvo.util.StringUtils;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseTree;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebCrawlspaceBranch
extends CrawlspaceBranch {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected static final String WebBranchElement = "web_branch";
    protected static final String AllowRulesElement = "allow_rules";
    protected static final String AllowRuleElement = "allow_rule";
    private static final String WebSeparatorChar = "/";
    private static final String ProtocolSeparator = "://";
    private static final String[] GlobalDomainPrefixes = new String[]{"www.", "w3."};
    private Vector<String> allowRules = new Vector();
    private HttpAuth httpAuth = null;

    public HttpAuth getHttpAuth() {
        return this.httpAuth;
    }

    public void setHttpAuth(HttpAuth httpAuth) {
        this.httpAuth = httpAuth;
    }

    public void generateDefaultAllowRules() {
        String rootURL = this.getRoot();
        this.allowRules.clear();
        this.allowRules.addAll(WebCrawlspaceBranch.generateAllowRulesFor(rootURL));
    }

    public Vector<String> getAllowRules() {
        return this.allowRules;
    }

    public static Vector<String> generateAllowRulesFor(String rootURL) {
        Vector<String> allowRules = new Vector<String>();
        if (rootURL != null && rootURL.length() != 0) {
            String startURL = CollectionCrawlspaceConfigurationManager.generateStartURLForWebCrawlspace(rootURL);
            StringBuilder[] localAllowRules = null;
            int indexAfterProtocol = startURL.indexOf(ProtocolSeparator) + ProtocolSeparator.length();
            String protocol = startURL.substring(0, indexAfterProtocol);
            int globalDomainPrefixIndex = -1;
            if (startURL.length() > indexAfterProtocol + GlobalDomainPrefixes[0].length()) {
                for (int i = 0; i < GlobalDomainPrefixes.length && globalDomainPrefixIndex < 0; ++i) {
                    String str = startURL.substring(indexAfterProtocol);
                    if (!StringUtils.startsWithIgnoreCase(str, GlobalDomainPrefixes[i])) continue;
                    globalDomainPrefixIndex = i;
                }
            }
            if (globalDomainPrefixIndex < 0) {
                if (WebCrawlspaceBranch.isNumericHostName(startURL)) {
                    localAllowRules = new StringBuilder[]{new StringBuilder(startURL.length() + 10)};
                    localAllowRules[0].append(startURL);
                } else {
                    localAllowRules = new StringBuilder[]{new StringBuilder(startURL.length() + 10), new StringBuilder(startURL.length() + 10)};
                    localAllowRules[0].append(startURL);
                    localAllowRules[1].append(protocol);
                    localAllowRules[1].append("*.");
                    localAllowRules[1].append(startURL.substring(indexAfterProtocol));
                }
            } else {
                localAllowRules = new StringBuilder[]{new StringBuilder(startURL.length() + 10)};
                localAllowRules[0].append(protocol);
                localAllowRules[0].append("*.");
                String textAfterGlobalPrefix = startURL.substring(indexAfterProtocol + GlobalDomainPrefixes[globalDomainPrefixIndex].length());
                localAllowRules[0].append(textAfterGlobalPrefix);
            }
            Vector<String> finalRules = WebCrawlspaceBranch.buildAllowRulesSuffix(localAllowRules, indexAfterProtocol);
            allowRules.addAll(finalRules);
        }
        return allowRules;
    }

    @Override
    public void writeTo(XMLTagger tagger) throws ExtendedException {
        tagger.startElement(WebBranchElement);
        super.writeContentsTo(tagger);
        if (this.allowRules.size() > 0) {
            tagger.startElement(AllowRulesElement);
            for (int i = 0; i < this.allowRules.size(); ++i) {
                tagger.startElement(AllowRuleElement);
                tagger.writeText(this.allowRules.get(i));
                tagger.endElement(AllowRuleElement);
            }
            tagger.endElement(AllowRulesElement);
        }
        if (this.httpAuth != null) {
            this.httpAuth.writeTo(tagger);
        }
        tagger.endElement(WebBranchElement);
    }

    protected static void prepareParseTree(String parentPath, ParseTree tree) {
        if (!parentPath.endsWith(WebSeparatorChar)) {
            parentPath = parentPath + WebSeparatorChar;
        }
        parentPath = parentPath + WebBranchElement + WebSeparatorChar;
        WebCrawlspaceBranch.addContentsToParseTree(parentPath, tree);
        tree.addSetSubcomponent(parentPath + "http_basic_auth", "createHttpBasicAuth");
        HttpBasicAuth.prepareParseTree(parentPath, tree);
        tree.addSetSubcomponent(parentPath + "http_form_auth", "createHttpFormAuth");
        HttpFormAuth.prepareParseTree(parentPath, tree);
        tree.addCallMethod(parentPath + AllowRulesElement + WebSeparatorChar + AllowRuleElement, "addAllowRule");
    }

    public HttpAuth createHttpBasicAuth() {
        this.httpAuth = new HttpBasicAuth();
        return this.httpAuth;
    }

    public HttpAuth createHttpFormAuth() {
        this.httpAuth = new HttpFormAuth();
        return this.httpAuth;
    }

    public void addAllowRule(String rule) {
        this.allowRules.add(rule);
    }

    private static Vector<String> buildAllowRulesSuffix(StringBuilder[] baseAllowRules, int endOfProtocolIndex) {
        Vector<String> localAllowRules = new Vector<String>();
        for (int i = 0; i < baseAllowRules.length; ++i) {
            String tempRule = baseAllowRules[i].toString();
            if (tempRule.endsWith(WebSeparatorChar)) {
                localAllowRules.add(tempRule + "*");
                continue;
            }
            int index = tempRule.lastIndexOf(WebSeparatorChar);
            if (index >= endOfProtocolIndex) {
                localAllowRules.add(tempRule.substring(0, index + 1) + "*");
                continue;
            }
            localAllowRules.add(tempRule + WebSeparatorChar + "*");
        }
        return localAllowRules;
    }

    private static boolean isNumericHostName(String strUrl) {
        boolean isNumeric = false;
        try {
            URL url = new URL(strUrl);
            String hostName = url.getHost();
            if (hostName != null && hostName.length() > 0) {
                isNumeric = true;
                for (int i = 0; i < hostName.length() && isNumeric; ++i) {
                    char ch = hostName.charAt(i);
                    if (ch >= '0' && ch <= '9' || ch == '.') continue;
                    isNumeric = false;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return isNumeric;
    }
}

