/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawlspace;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.crawlspace.HttpProxySettings;
import com.ibm.es.nuvo.crawlspace.WebCrawlspaceBranch;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseTree;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebCrawlspace {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected static final String WebCrawlspaceElement = "web_cs";
    protected static final String EmailElement = "email";
    protected static final String CrawlerNameElement = "crawler_name";
    protected static final String PolitnessElement = "politness";
    private int politness = 500;
    private String emailId = null;
    private String crawlerName = null;
    private Vector<WebCrawlspaceBranch> branches = new Vector();
    private HttpProxySettings httpProxy = null;

    public Vector<WebCrawlspaceBranch> getBranches() {
        return this.branches;
    }

    public void setBranches(Vector<WebCrawlspaceBranch> branches) {
        this.branches = branches;
    }

    public String getCrawlerName() {
        return this.crawlerName;
    }

    public void setCrawlerName(String crawlerName) {
        this.crawlerName = crawlerName;
    }

    public String getEmailId() {
        return this.emailId;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    public int getPolitness() {
        return this.politness;
    }

    public void setPolitness(int politness) {
        this.politness = politness;
    }

    public void setPolitnessString(String strPolitness) {
        this.setPolitness(Integer.parseInt(strPolitness));
    }

    public HttpProxySettings getHttpProxy() {
        return this.httpProxy;
    }

    public void setHttpProxy(HttpProxySettings httpProxy) {
        this.httpProxy = httpProxy;
    }

    public void writeTo(XMLTagger tagger) throws ExtendedException {
        tagger.startElement(WebCrawlspaceElement);
        tagger.startElement(PolitnessElement);
        tagger.writeText(Integer.toString(this.politness));
        tagger.endElement(PolitnessElement);
        if (this.crawlerName != null) {
            tagger.startElement(CrawlerNameElement);
            tagger.writeText(this.crawlerName);
            tagger.endElement(CrawlerNameElement);
        }
        if (this.emailId != null) {
            tagger.startElement(EmailElement);
            tagger.writeText(this.emailId);
            tagger.endElement(EmailElement);
        }
        if (this.httpProxy != null) {
            this.httpProxy.writeTo(tagger);
        }
        if (this.branches != null) {
            for (int i = 0; i < this.branches.size(); ++i) {
                WebCrawlspaceBranch branch = this.branches.elementAt(i);
                if (branch == null) continue;
                branch.writeTo(tagger);
            }
        }
        tagger.endElement(WebCrawlspaceElement);
    }

    protected static void prepareParseTree(String parentPath, ParseTree tree) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        parentPath = parentPath + WebCrawlspaceElement + "/";
        tree.addCallMethod(parentPath + EmailElement, "setEmailId");
        tree.addCallMethod(parentPath + CrawlerNameElement, "setCrawlerName");
        tree.addCallMethod(parentPath + PolitnessElement, "setPolitnessString");
        tree.addSetSubcomponent(parentPath + "http_proxy", "createHttpProxy");
        tree.addSetSubcomponent(parentPath + "web_branch", "createBranch");
        HttpProxySettings.prepareParseTree(parentPath, tree);
        WebCrawlspaceBranch.prepareParseTree(parentPath, tree);
    }

    public WebCrawlspaceBranch createBranch() {
        WebCrawlspaceBranch branch = new WebCrawlspaceBranch();
        this.branches.add(branch);
        return branch;
    }

    public HttpProxySettings createHttpProxy() {
        this.httpProxy = new HttpProxySettings();
        return this.httpProxy;
    }
}

