/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawlspace;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.util.Encryption;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseTree;

public class HttpProxySettings {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected static final String HttpProxyElement = "http_proxy";
    private static final String DomainElement = "domain";
    private static final String PortElement = "port";
    private static final String HostElement = "host";
    private static final String UserIdElement = "user";
    private static final String PasswordElement = "pwd";
    private String domainName = null;
    private String hostName = null;
    private String userId = null;
    private String password = null;
    private int port = 0;

    public String getDomainName() {
        return this.domainName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEncryptedPassword(String base64EncryptedByteArray) throws ExtendedException {
        String decryptedPwd = Encryption.decrypt(base64EncryptedByteArray);
        this.setPassword(decryptedPwd);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPortString(String strPort) {
        this.setPort(Integer.parseInt(strPort));
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void writeTo(XMLTagger tagger) throws ExtendedException {
        tagger.startElement(HttpProxyElement);
        if (this.domainName != null) {
            tagger.startElement(DomainElement);
            tagger.writeText(this.domainName);
            tagger.endElement(DomainElement);
        }
        if (this.hostName != null) {
            tagger.startElement(HostElement);
            tagger.writeText(this.hostName);
            tagger.endElement(HostElement);
        }
        if (this.port != 0) {
            tagger.startElement(PortElement);
            tagger.writeText(Integer.toString(this.port));
            tagger.endElement(PortElement);
        }
        if (this.userId != null) {
            tagger.startElement(UserIdElement);
            tagger.writeText(this.userId);
            tagger.endElement(UserIdElement);
        }
        if (this.password != null) {
            tagger.startElement(PasswordElement);
            String encryptedPwd = Encryption.encrypt(this.password);
            tagger.writeText(encryptedPwd);
            tagger.endElement(PasswordElement);
        }
        tagger.endElement(HttpProxyElement);
    }

    protected static void prepareParseTree(String parentPath, ParseTree tree) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        parentPath = parentPath + HttpProxyElement + "/";
        tree.addCallMethod(parentPath + DomainElement, "setDomainName");
        tree.addCallMethod(parentPath + HostElement, "setHostName");
        tree.addCallMethod(parentPath + PortElement, "setPortString");
        tree.addCallMethod(parentPath + UserIdElement, "setUserId");
        tree.addCallMethod(parentPath + PasswordElement, "setEncryptedPassword");
    }
}

