/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawlspace;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.crawlspace.HttpAuth;
import com.ibm.es.nuvo.util.Encryption;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseTree;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpFormAuth
extends HttpAuth {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String[] ElementPropertyAttributes = new String[]{"name", "value"};
    private static final String[] ElementPropertyAttributesDefaults = new String[]{"", ""};
    private static final String ElementProperty = "property";
    private static final String AttrPropertyName = "name";
    private static final String AttrPropertyValue = "value";
    protected static final String HttpFormAuthElement = "http_form_auth";
    private static final String ActionElement = "action";
    private static final String NameElement = "form_name";
    private static final String MethodElement = "method";
    private String formAction = null;
    private String formName = null;
    private HttpMethodType httpMethod = HttpMethodType.Get;
    private HashMap<String, String> formParameters = new HashMap();

    public String getFormAction() {
        return this.formAction;
    }

    public String getFormName() {
        return this.formName;
    }

    public HashMap<String, String> getFormParameters() {
        return this.formParameters;
    }

    public String getFormParameter(String parmName) {
        String value = null;
        if (this.formParameters != null) {
            value = this.formParameters.get(parmName);
        }
        return value;
    }

    public HttpMethodType getHttpMethod() {
        return this.httpMethod;
    }

    public void setFormAction(String formAction) {
        this.formAction = formAction;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public void setFormParameters(HashMap<String, String> formParameters) {
        this.formParameters = formParameters;
    }

    public void setFormParameter(String parmName, String parmValue) {
        if (this.formParameters == null) {
            this.formParameters = new HashMap();
        }
        this.formParameters.put(parmName, parmValue);
    }

    public void setEncryptedFormParameter(String parmName, String encryptedValue) throws ExtendedException {
        String decryptedValue = Encryption.decrypt(encryptedValue);
        this.setFormParameter(parmName, decryptedValue);
    }

    public void setHttpMethod(HttpMethodType httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setHttpMethodString(String strHttpMethod) {
        if (HttpMethodType.Get.toString().equals(strHttpMethod)) {
            this.setHttpMethod(HttpMethodType.Get);
        } else if (HttpMethodType.Post.toString().equals(strHttpMethod)) {
            this.setHttpMethod(HttpMethodType.Post);
        } else {
            throw new RuntimeException("Invalid string of http method type " + strHttpMethod + "  Must match to HttpFormAuth.HttpMethodType");
        }
    }

    @Override
    public void writeTo(XMLTagger xmlTagger) throws ExtendedException {
        xmlTagger.startElement(HttpFormAuthElement);
        if (this.formAction != null) {
            xmlTagger.startElement(ActionElement);
            xmlTagger.writeText(this.formAction);
            xmlTagger.endElement(ActionElement);
        }
        if (this.formName != null) {
            xmlTagger.startElement(NameElement);
            xmlTagger.writeText(this.formName);
            xmlTagger.endElement(NameElement);
        }
        xmlTagger.startElement(MethodElement);
        xmlTagger.writeText(this.httpMethod.toString());
        xmlTagger.endElement(MethodElement);
        if (this.formParameters != null && this.formParameters.size() > 0) {
            for (Map.Entry<String, String> curEntry : this.formParameters.entrySet()) {
                xmlTagger.openStartElement(ElementProperty);
                xmlTagger.writeAttr(AttrPropertyName, curEntry.getKey());
                String encryptedValue = Encryption.encrypt(curEntry.getValue());
                xmlTagger.writeAttr(AttrPropertyValue, encryptedValue);
                xmlTagger.closeEndElementTag();
            }
        }
        xmlTagger.endElement(HttpFormAuthElement);
    }

    protected static void prepareParseTree(String parentPath, ParseTree tree) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        parentPath = parentPath + HttpFormAuthElement + "/";
        tree.addCallMethod(parentPath + ActionElement, "setFormAction");
        tree.addCallMethod(parentPath + NameElement, "setFormName");
        tree.addCallMethod(parentPath + MethodElement, "setHttpMethodString");
        tree.addCallMethod(parentPath + ElementProperty, "setEncryptedFormParameter", ElementPropertyAttributes, ElementPropertyAttributesDefaults);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HttpMethodType {
        Get,
        Post;

    }
}

