/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawlspace;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.crawlspace.HttpAuth;
import com.ibm.es.nuvo.util.Encryption;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseTree;

public class HttpBasicAuth
extends HttpAuth {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected static final String HttpBasicAuthElement = "http_basic_auth";
    private static final String UserIdElement = "user";
    private static final String PasswordElement = "pwd";
    private String userId = null;
    private String password = null;

    public String getPassword() {
        return this.password;
    }

    public void setEncryptedPassword(String base64EncryptedByteArray) throws ExtendedException {
        String decryptedPwd = Encryption.decrypt(base64EncryptedByteArray);
        this.setPassword(decryptedPwd);
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void writeTo(XMLTagger tagger) throws ExtendedException {
        tagger.startElement(HttpBasicAuthElement);
        if (this.userId != null) {
            tagger.startElement(UserIdElement);
            tagger.writeText(this.userId);
            tagger.endElement(UserIdElement);
        }
        if (this.password != null) {
            tagger.startElement(PasswordElement);
            String encryptedPwd = Encryption.encrypt(this.password);
            tagger.writeText(encryptedPwd);
            tagger.endElement(PasswordElement);
        }
        tagger.endElement(HttpBasicAuthElement);
    }

    protected static void prepareParseTree(String parentPath, ParseTree tree) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        parentPath = parentPath + HttpBasicAuthElement + "/";
        tree.addCallMethod(parentPath + UserIdElement, "setUserId");
        tree.addCallMethod(parentPath + PasswordElement, "setEncryptedPassword");
    }
}

