/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawlspace;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseTree;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrawlspaceBranch {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected static final String BranchElement = "branch";
    private static final String RootElement = "rootName";
    private static final String DenyListElement = "deny_list";
    private static final String PatternElement = "pattern";
    private String root = null;
    private Vector<String> denyPatterns = new Vector();

    public Vector<String> getDenyPatterns() {
        return this.denyPatterns;
    }

    public void setDenyPatterns(Vector<String> denyPatterns) {
        this.denyPatterns = denyPatterns;
    }

    public void setDenyPattern(String denyPattern) {
        if (this.denyPatterns == null) {
            this.denyPatterns = new Vector();
        }
        this.denyPatterns.add(denyPattern);
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void writeTo(XMLTagger tagger) throws ExtendedException {
        tagger.startElement(BranchElement);
        this.writeContentsTo(tagger);
        tagger.endElement(BranchElement);
    }

    protected void writeContentsTo(XMLTagger tagger) throws ExtendedException {
        tagger.startElement(RootElement);
        if (this.root != null) {
            tagger.writeText(this.root);
        }
        tagger.endElement(RootElement);
        if (this.denyPatterns != null) {
            tagger.startElement(DenyListElement);
            for (int i = 0; i < this.denyPatterns.size(); ++i) {
                String pattern = this.denyPatterns.elementAt(i);
                if (pattern == null || pattern.length() <= 0) continue;
                tagger.startElement(PatternElement);
                tagger.writeText(pattern);
                tagger.endElement(PatternElement);
            }
            tagger.endElement(DenyListElement);
        }
    }

    protected static void prepareParseTree(String parentPath, ParseTree tree) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        parentPath = parentPath + BranchElement + "/";
        CrawlspaceBranch.addContentsToParseTree(parentPath, tree);
    }

    protected static void addContentsToParseTree(String parentPath, ParseTree tree) {
        tree.addCallMethod(parentPath + RootElement, "setRoot");
        tree.addCallMethod(parentPath + DenyListElement + "/" + PatternElement, "setDenyPattern");
    }
}

