/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.util;

import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLFormatHandler
extends DefaultHandler {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String SPACES = "                                                        ";
    private StringBuilder builder;
    private Stack<String> stack;
    private boolean open;
    private boolean simple;

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.open) {
            this.builder.append("> ");
        }
        this.open = false;
        this.builder.append(ch, start, length);
        this.simple = true;
    }

    public void startDocument() throws SAXException {
        this.builder = new StringBuilder();
        this.stack = new Stack();
    }

    public void endDocument() throws SAXException {
        System.out.println(this.builder.toString());
        this.builder = null;
    }

    public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
        if (this.open) {
            this.builder.append(">\n");
        }
        this.padding();
        this.open = true;
        this.builder.append("<");
        this.builder.append(qname);
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.builder.append(" ");
            this.builder.append(attributes.getQName(i));
            this.builder.append("=\"");
            this.builder.append(attributes.getValue(i));
            this.builder.append("\"");
        }
        this.stack.push(qname);
        this.simple = false;
    }

    public void endElement(String uri, String localName, String qname) throws SAXException {
        String name = this.stack.pop();
        if (this.open) {
            this.builder.append(" />\n");
        } else {
            if (!this.simple) {
                this.padding();
            } else {
                this.builder.append(" ");
            }
            this.builder.append("</");
            this.builder.append(name);
            this.builder.append(">\n");
        }
        this.open = false;
    }

    private void padding() {
        this.builder.append(SPACES.toCharArray(), 0, this.stack.size() * 2);
    }
}

