/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.util;

import com.ibm.es.nuvo.crawler.util.hash.HashSeed;
import com.ibm.es.nuvo.crawler.util.hash.HashUtil;
import com.ibm.es.nuvo.crawler.util.hash.HashableDataBufferOutputStream;
import com.ibm.es.nuvo.crawler.web.util.StreamUtils;
import com.ibm.es.nuvo.util.databuffer.DataBufferException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class BloomFilter
implements Serializable {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = 8118681251216446570L;
    private int[] filterData;
    private HashSeed[] seeds;
    private int count;
    private static final int UNIT = 32;
    private double trustErrorRate = 1.0E-6;
    private boolean failed;
    private int maxTrust;
    private transient int length;

    public BloomFilter(int size, int numHash) {
        this.seeds = new HashSeed[numHash];
        for (int i = 0; i < numHash; ++i) {
            this.seeds[i] = new HashSeed();
        }
        this.filterData = new int[size];
        this.setTrustErrorRate(this.trustErrorRate);
    }

    public boolean add(byte[] data) {
        long[] keys = this.getHashes(data);
        return this.addHash(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addHash(long[] keys) {
        boolean exist = true;
        int[] nArray = this.filterData;
        synchronized (this.filterData) {
            for (long key : keys) {
                int i = this.getIndex(key);
                int b = this.filterData[i];
                int mask = 1 << (int)(key % 32L);
                if (exist && (b & mask) == 0) {
                    exist = false;
                }
                this.filterData[i] = b |= mask;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (!exist) {
                ++this.count;
            }
            return exist;
        }
    }

    private int getIndex(long key) {
        return ((int)(key >> 32) % this.filterData.length + this.filterData.length) % this.filterData.length;
    }

    public boolean contains(byte[] data) {
        long[] keys = this.getHashes(data);
        return this.containsHash(keys);
    }

    public boolean contains(long data) {
        long[] keys = this.getHashes(this.longToBytes(data));
        return this.containsHash(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsHash(long[] keys) {
        int[] nArray = this.filterData;
        synchronized (this.filterData) {
            for (long key : keys) {
                int mask;
                int i = this.getIndex(key);
                int b = this.filterData[i];
                if ((b & (mask = 1 << (int)(key % 32L))) != 0) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    public double getErrorRate() {
        return BloomFilter.getErrorRate(this.count, this.seeds.length, this.getNumBits());
    }

    private long[] getHashes(byte[] data) {
        long[] ret = new long[this.seeds.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = HashUtil.hashCode64(data, this.seeds[i].getSeed(), this.seeds[i].getRand());
        }
        return ret;
    }

    public static double getErrorRate(int numKeys, int numHash, int numBits) {
        double ret = Math.pow(1.0 - Math.exp(-((double)numHash) * (double)numKeys / (double)numBits), numHash);
        return ret;
    }

    public static double getOptimalErrorRate(int numKeys, int numBits) {
        int numHash = BloomFilter.getOptimalKeySize(numKeys, numBits);
        double ret = Math.pow(1.0 - Math.exp(-((double)numHash) * (double)numKeys / (double)numBits), numHash);
        return ret;
    }

    public static double getRequiredSize(int numKeys, int numHash, double rate) {
        double ret = -((double)numHash) * (double)numKeys / Math.log(1.0 - Math.pow(rate, 1.0 / (double)numHash));
        return ret;
    }

    public static int getOptimalKeySize(int numKeys, int numBits) {
        double rate = Math.log(2.0) * ((double)numBits / (double)numKeys);
        return (int)rate + 1;
    }

    public double getTrustErrorRate() {
        return this.trustErrorRate;
    }

    public void setTrustErrorRate(double trustErrorRate) {
        this.trustErrorRate = trustErrorRate;
        int numHash = this.seeds.length;
        this.maxTrust = (int)(-((double)this.getNumBits()) * Math.log(1.0 - Math.pow(this.trustErrorRate, 1.0 / (double)numHash)) / (double)numHash) + 1;
    }

    public boolean canTrust() {
        return this.count < this.maxTrust && !this.failed;
    }

    public int getMaxTrust() {
        return this.maxTrust;
    }

    public double getOptimalErrorRate() {
        return BloomFilter.getOptimalErrorRate(this.count, this.getNumBits());
    }

    private int getNumBits() {
        return this.filterData.length * 32;
    }

    public int getOptimalKeySize() {
        return BloomFilter.getOptimalKeySize(this.count, this.getNumBits());
    }

    public boolean add(int value) {
        byte[] bs = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bs[i] = (byte)(value >> i * 8 & 0xFF);
        }
        return this.add(bs);
    }

    public boolean add(long value) {
        byte[] bs = this.longToBytes(value);
        return this.add(bs);
    }

    private byte[] longToBytes(long value) {
        byte[] bs = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bs[i] = (byte)(value >> i * 8 & 0xFFL);
        }
        return bs;
    }

    public InputStream getInputStream() throws IOException, DataBufferException {
        HashableDataBufferOutputStream os = new HashableDataBufferOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(this);
        StreamUtils.safeClose(oos);
        StreamUtils.safeClose(os);
        InputStream is = os.getInputStream();
        this.length = os.length();
        os.dispose();
        return is;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public int getSizeInBytes() {
        return this.length;
    }
}

