/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.thread;

import com.ibm.es.nuvo.crawler.web.error.DuplicateNameException;
import com.ibm.es.nuvo.crawler.web.thread.WCRunnable;
import com.ibm.es.nuvo.crawler.web.thread.WCThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WCThreadManager {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static WCThreadManager s_instance = new WCThreadManager();
    private HashMap<String, ThreadGroup> m_threadGroups = new HashMap();
    private HashMap<String, WCThread> m_threads = new HashMap();

    public static WCThreadManager instance() {
        return s_instance;
    }

    private WCThreadManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadGroup createThreadGroup(String name) throws DuplicateNameException {
        HashMap<String, ThreadGroup> hashMap = this.m_threadGroups;
        synchronized (hashMap) {
            ThreadGroup tg = null;
            tg = new ThreadGroup(name);
            ThreadGroup old = this.m_threadGroups.put(name, tg);
            if (old != null) {
                throw new DuplicateNameException(name, "ThreadGroups");
            }
            return tg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WCThread createThread(String threadGroupName, WCRunnable r, String threadName) throws DuplicateNameException {
        HashMap<String, WCThread> hashMap = this.m_threads;
        synchronized (hashMap) {
            WCThread old;
            ThreadGroup tg = this.m_threadGroups.get(threadGroupName);
            if (tg == null) {
                tg = this.createThreadGroup(threadGroupName);
            }
            if ((old = this.m_threads.remove(threadName)) != null && old.isAlive()) {
                throw new DuplicateNameException(threadName, "Threads");
            }
            WCThread th = new WCThread(tg, r, threadName);
            this.m_threads.put(threadName, th);
            th.setDaemon(true);
            return th;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadGroup getThreadGroup(String name) {
        HashMap<String, ThreadGroup> hashMap = this.m_threadGroups;
        synchronized (hashMap) {
            return this.m_threadGroups.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread(String name) {
        HashMap<String, WCThread> hashMap = this.m_threads;
        synchronized (hashMap) {
            return this.m_threads.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<WCThread> getThreads() {
        HashMap<String, WCThread> hashMap = this.m_threads;
        synchronized (hashMap) {
            TreeMap<String, WCThread> ts = new TreeMap<String, WCThread>();
            ts.putAll(this.m_threads);
            return ts.values();
        }
    }

    public String getStatus1() {
        int k;
        int[] cw;
        int j;
        int k2;
        StringBuffer sb = new StringBuffer();
        ArrayList<WCThread.Status1> al = new ArrayList<WCThread.Status1>();
        Iterator<WCThread> it = this.getThreads().iterator();
        while (it.hasNext()) {
            al.add(it.next().getStatus1());
        }
        String[] cn = WCThread.Status1.getColNames();
        int nc = cn.length;
        int[] ccw = new int[nc];
        for (k2 = 0; k2 < nc; ++k2) {
            ccw[k2] = cn[k2].length();
        }
        for (j = 0; j < al.size(); ++j) {
            WCThread.Status1 s = (WCThread.Status1)al.get(j);
            cw = s.getColWidths();
            for (k = 0; k < nc; ++k) {
                ccw[k] = Math.max(ccw[k], cw[k]);
            }
        }
        for (k2 = 0; k2 < nc; ++k2) {
            sb.append(cn[k2]);
            for (int l = 0; l < ccw[k2] - cn[k2].length() + 1; ++l) {
                sb.append(" ");
            }
        }
        sb.append("\n");
        for (j = 0; j < al.size(); ++j) {
            WCThread.Status1 s = (WCThread.Status1)al.get(j);
            cw = s.getColWidths();
            for (k = 0; k < nc; ++k) {
                sb.append(s.getCol(k));
                for (int l = 0; l < ccw[k] - cw[k] + 1; ++l) {
                    sb.append(" ");
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

