/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.thread;

import com.ibm.es.nuvo.crawler.web.thread.WCRunnable;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.util.logging.Level;

public class WCThread
extends Thread {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + WCThread.class.getName());
    private long m_creationTime = System.currentTimeMillis();
    private long m_startTime;
    private long m_stopTime;
    private WCRunnable m_runnable;

    public WCThread(ThreadGroup tg, WCRunnable r, String name) {
        super(tg, r, name);
        this.m_runnable = r;
    }

    public WCRunnable getRunnable() {
        return this.m_runnable;
    }

    public long getCreationTime() {
        return this.m_creationTime;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public long getStopTime() {
        return this.m_stopTime;
    }

    public Status1 getStatus1() {
        return new Status1(this);
    }

    public String getStatus2() {
        return super.toString();
    }

    public void setStopTime() {
        this.m_stopTime = System.currentTimeMillis();
    }

    public void start() {
        this.m_startTime = System.currentTimeMillis();
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("Starting " + this + "@" + this.hashCode());
        }
        super.start();
    }

    public void sleepSec(int sec) throws InterruptedException {
        WCThread.sleep((long)sec * 1000L);
    }

    public static class Status1 {
        public static final int s_nCol = 12;
        private static final String[] s_colNames = new String[]{"Thr", "TGrp", "Alv", "Dmn", "Int", "Rnbl", "RLvl", "SubRL", "Created", "Started", "Stopped", "Term"};
        private String m_threadName;
        private String m_threadGroupName;
        private String m_runnableName;
        private String m_runLevelName;
        private String m_subRunLevel;
        private boolean m_isAlive;
        private boolean m_isDaemon;
        private boolean m_isInterrupted;
        private String m_creationTime;
        private String m_startTime;
        private String m_stopTime;
        private String m_tmanner;
        private int[] m_colWidths = new int[s_colNames.length];

        public Status1(WCThread t) {
            if (t == null) {
                return;
            }
            this.m_threadName = t.getName();
            this.m_colWidths[0] = this.m_threadName.length();
            ThreadGroup tg = t.getThreadGroup();
            this.m_threadGroupName = tg == null ? "null" : tg.getName();
            this.m_colWidths[1] = this.m_threadGroupName.length();
            this.m_isAlive = t.isAlive();
            this.m_colWidths[2] = this.m_isAlive ? 3 : 2;
            this.m_isDaemon = t.isDaemon();
            this.m_colWidths[3] = this.m_isDaemon ? 3 : 2;
            this.m_isInterrupted = t.isInterrupted();
            this.m_colWidths[4] = this.m_isInterrupted ? 3 : 2;
            WCRunnable r = t.getRunnable();
            this.m_runnableName = r == null ? "null" : r.getName();
            this.m_colWidths[5] = this.m_runnableName.length();
            this.m_runLevelName = r == null ? "null" : r.getRunLevelName();
            this.m_colWidths[6] = this.m_runLevelName.length();
            this.m_subRunLevel = r == null ? "null" : r.getSubRunLevel();
            this.m_colWidths[7] = this.m_subRunLevel.length();
            this.m_creationTime = String.valueOf(t.getCreationTime());
            this.m_colWidths[8] = this.m_creationTime.length();
            this.m_startTime = String.valueOf(t.getStartTime());
            this.m_colWidths[9] = this.m_startTime.length();
            this.m_stopTime = String.valueOf(t.getStopTime());
            this.m_colWidths[10] = this.m_stopTime.length();
            this.m_tmanner = r == null ? "null" : r.getTerminationMannerName(r.getTerminationManner());
            this.m_colWidths[11] = this.m_tmanner.length();
        }

        public int[] getColWidths() {
            int[] retCopy = new int[this.m_colWidths.length];
            System.arraycopy(this.m_colWidths, 0, retCopy, 0, retCopy.length);
            return retCopy;
        }

        public String getCol(int n) {
            switch (n) {
                case 0: {
                    return this.m_threadName;
                }
                case 1: {
                    return this.m_threadGroupName;
                }
                case 2: {
                    return this.m_isAlive ? "yes" : "no";
                }
                case 3: {
                    return this.m_isDaemon ? "yes" : "no";
                }
                case 4: {
                    return this.m_isInterrupted ? "yes" : "no";
                }
                case 5: {
                    return this.m_runnableName;
                }
                case 6: {
                    return this.m_runLevelName;
                }
                case 7: {
                    return this.m_subRunLevel;
                }
                case 8: {
                    return this.m_creationTime;
                }
                case 9: {
                    return this.m_startTime;
                }
                case 10: {
                    return this.m_stopTime;
                }
                case 11: {
                    return this.m_tmanner;
                }
            }
            return "invalid";
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < 12; ++j) {
                sb.append(this.getCol(j)).append(j < 10 ? "|" : "");
            }
            return sb.toString();
        }

        public static String[] getColNames() {
            String[] ret = new String[s_colNames.length];
            for (int i = 0; i < s_colNames.length; ++i) {
                ret[i] = s_colNames[i];
            }
            return ret;
        }

        public static String getColName(int n) {
            return n >= 0 && n <= s_colNames.length ? s_colNames[n] : "invalid";
        }
    }
}

