/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.thread;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.web.error.ArgCheck;
import com.ibm.es.nuvo.crawler.web.error.GenericException;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.thread.WCRunnable;
import com.ibm.es.nuvo.crawler.web.thread.WCThread;
import com.ibm.es.nuvo.crawler.web.thread.WCThreadInfo;
import com.ibm.es.nuvo.crawler.web.thread.WCThreadManager;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;

public abstract class WCRunnableImpl
implements WCRunnable,
WCThreadInfo {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static ExtendedLogger logger = Loggers.logger;
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + WCRunnableImpl.class.getName());
    private static final String[] STATUS_NAMES = new String[]{"Blank", "Init", "Ready", "Starting", "Running", "Stopping", "Stopped", "Pausing", "Paused", "Resuming", "Releasing"};
    private static final String[] TERMINATINO_NAMES = new String[]{"Unterminated", "Success", "Error", "Exception"};
    private static final String s_superclassMethod = "Superclass method called";
    private static int[][] s_legalNextStates = new int[][]{{1, -1}, {2, -1}, {3, 10}, {4, -1}, {5, 7}, {6, -1}, {10, -1}, {8, -1}, {9, 5}, {4, -1}, {0, -1}};
    protected boolean stopRequested;
    protected String m_subRunLevel = "";
    protected String m_name;
    private int m_runLevel = 0;
    private Object m_runLevelSync = new Object();
    private boolean m_configured = true;
    private boolean m_runEntered;
    private boolean m_runExited;
    protected boolean m_pauseRequested;
    private int m_terminationManner = 0;
    protected String m_terminationStackTraceListing;
    private Throwable m_terminationThrowable;
    private WCThread m_thread;

    protected WCRunnableImpl(String name) {
        if (name == null) {
            name = Thread.currentThread().getName();
            if (tracer.isLoggable(Level.FINER)) {
                tracer.log(Level.FINE, "Name was assigned from thread name. " + name);
            }
        }
        this.m_name = name;
    }

    public final void init() throws WCException {
        this._exec(1);
    }

    public final void start() throws WCException {
        this._exec(3);
    }

    public final void pause() throws WCException {
        this._exec(7);
    }

    public final void resume() throws WCException {
        this._exec(9);
    }

    public final void stop() throws WCException {
        this._exec(5);
    }

    public final void release() throws WCException {
        this._exec(10);
    }

    public final void run() {
        try {
            this.m_runEntered = true;
            this._clientRun();
            this._terminated();
        }
        catch (InterruptedException ignored) {
        }
        catch (WCException wce) {
            this._terminated(wce);
        }
        catch (Exception e) {
            this._terminated(e);
        }
        catch (OutOfMemoryError oome) {
            throw oome;
        }
        finally {
            this.m_runExited = true;
        }
    }

    public WCThread.Status1 getStatus1() {
        if (this._getThread() != null) {
            return this._getThread().getStatus1();
        }
        return new WCThread.Status1(null);
    }

    private final void _exec(int entryState) throws WCException {
        if (entryState == 5) {
            this.stopRequested = true;
        } else if (entryState == 1) {
            this.stopRequested = false;
        }
        this._setRunLevel(entryState);
        try {
            switch (entryState) {
                case 1: {
                    this._checkConfigured();
                    this._clientInit();
                    break;
                }
                case 3: {
                    this._clientStart();
                    break;
                }
                case 7: {
                    this.m_pauseRequested = true;
                    this._clientPause();
                    break;
                }
                case 9: {
                    this.m_pauseRequested = false;
                    this._clientResume();
                    break;
                }
                case 5: {
                    this._clientStop();
                    break;
                }
                case 10: {
                    this._clientRelease();
                }
            }
        }
        catch (WCException wce) {
            this._terminated(wce);
            throw wce;
        }
        catch (Exception e) {
            this._terminated(e);
            throw new GenericException("Exception while " + entryState);
        }
        this._setRunLevel(s_legalNextStates[entryState][0]);
    }

    public String getName() {
        return this.m_name;
    }

    public int getRunLevel() {
        return this.m_runLevel;
    }

    public String getRunLevelName() {
        return this._getRunLevelName(this.m_runLevel);
    }

    protected String _getRunLevelName(int rl) {
        return rl >= 0 && rl <= 10 ? STATUS_NAMES[rl] : "Invalid";
    }

    public String getSubRunLevel() {
        return this.m_subRunLevel;
    }

    public int getTerminationManner() {
        return this.m_terminationManner;
    }

    public String getTerminationMannerName(int tm) {
        return tm >= 0 && tm <= 3 ? TERMINATINO_NAMES[tm] : "Invalid";
    }

    public String getTerminationStackTraceListing() {
        return this.m_terminationStackTraceListing;
    }

    public Throwable getTerminationThrowable() {
        return this.m_terminationThrowable;
    }

    protected void _handlePause() throws InterruptedException {
        while (this.m_pauseRequested) {
            this._getThread().sleepSec(1);
        }
    }

    public boolean isConfigured() {
        return this.m_configured;
    }

    public boolean isRunning() {
        return this.m_runLevel == 4;
    }

    protected void setConfigured(boolean yesno) {
        this.m_configured = yesno;
    }

    public boolean wasRunEntered() {
        return this.m_runEntered;
    }

    public boolean wasRunExited() {
        return this.m_runExited;
    }

    protected void _clientInit() throws Exception {
        throw new Exception(s_superclassMethod);
    }

    protected void _clientStart() throws Exception {
        if (this.m_thread != null) {
            this.m_thread.start();
        }
    }

    protected void _clientPause() throws Exception {
    }

    protected void _clientResume() throws Exception {
    }

    protected void _clientStop() throws Exception {
        if (this.m_thread != null) {
            this.m_thread.setStopTime();
            this.m_thread.interrupt();
        }
    }

    protected void _clientRelease() throws Exception {
        throw new Exception(s_superclassMethod);
    }

    protected void _clientRunCore() throws Exception {
        throw new Exception(s_superclassMethod);
    }

    protected void _clientRun() throws Exception {
        while (!this._shouldStopLooping()) {
            if (this.m_pauseRequested) {
                while (this.m_pauseRequested) {
                    this._getThread().sleepSec(1);
                }
                continue;
            }
            this._clientRunCore();
        }
    }

    protected void _assignThread(String threadGroupName, String threadName) throws WCException {
        if (this.m_thread != null && this.m_thread.isAlive()) {
            ArgCheck.nullState("thread", this.m_thread);
        }
        WCThread thread = WCThreadManager.instance().createThread(threadGroupName, this, threadName);
        if (tracer.isLoggable(Level.FINE)) {
            tracer.fine("Created " + thread + "@" + thread.hashCode() + " for " + threadName + " ");
        }
        this.m_thread = thread;
    }

    protected void _checkConfigured() throws WCException {
        if (!this.m_configured) {
            throw new GenericException("Not configured " + this.getName());
        }
    }

    protected WCThread _getThread() {
        return this.m_thread;
    }

    protected boolean _pauseRequested() {
        return this.m_pauseRequested;
    }

    protected void setSubRunLevel(String newSubRL) {
        this.m_subRunLevel = newSubRL;
    }

    protected void _setStopTime() {
        if (this.m_thread != null) {
            this.m_thread.setStopTime();
        }
    }

    protected boolean _shouldStopLooping() {
        if (this.stopRequested || this.m_thread != null && this.m_thread.isInterrupted()) {
            if (this.m_thread != null && tracer.isLoggable(Level.FINE)) {
                tracer.fine("Stopped " + Thread.currentThread().getName());
            }
            return true;
        }
        return false;
    }

    public boolean stopPending() {
        return this.stopRequested;
    }

    protected boolean _stopRequested() {
        return this.stopRequested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _waitForState(int state) {
        Object object = this.m_runLevelSync;
        synchronized (object) {
            while (this.m_runLevel != state && !Thread.currentThread().isInterrupted()) {
                try {
                    this.m_runLevelSync.wait();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setRunLevel(int newRL) {
        Object object = this.m_runLevelSync;
        synchronized (object) {
            if (tracer.isLoggable(Level.FINER)) {
                tracer.log(Level.FINER, "Status of " + this.getName() + " is changed from " + this._getRunLevelName(this.m_runLevel) + " to " + this._getRunLevelName(newRL));
            }
            if (s_legalNextStates[this.m_runLevel][0] != newRL && s_legalNextStates[this.m_runLevel][1] != newRL && tracer.isLoggable(Level.FINER)) {
                tracer.log(Level.FINER, "IStatus of " + this.getName() + " is changed from " + this._getRunLevelName(this.m_runLevel) + " to " + this._getRunLevelName(newRL));
            }
            this.m_runLevel = newRL;
            this.m_runLevelSync.notifyAll();
        }
    }

    protected void _terminated() {
        this._setStopTime();
        this.m_terminationManner = 1;
    }

    protected void _terminated(Throwable throwable) {
        this._setStopTime();
        this.m_terminationThrowable = throwable;
        this.m_terminationManner = 3;
        if (logger.isLoggable(Level.SEVERE)) {
            Message message = new Message("C4813E.THREAD_TERMINATED", this.getName());
            ExtendedException exception = new ExtendedException(message, throwable);
            logger.log(Level.SEVERE, exception);
        }
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            this.m_terminationStackTraceListing = sw.toString();
        }
        catch (Exception ignored) {
            System.err.println("Exception saving stack trace for " + throwable.getMessage());
        }
    }

    public void interrupt() {
        if (this.m_thread != null) {
            this.m_thread.interrupt();
        }
    }
}

