/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.thread;

import com.ibm.es.nuvo.crawler.web.sync.FiniteQueue;
import com.ibm.es.nuvo.crawler.web.thread.WCRunnableImpl;
import com.ibm.es.nuvo.crawler.web.util.WCRequest;

public abstract class WCQRunnableImpl
extends WCRunnableImpl {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected FiniteQueue<WCRequest> m_queue = new FiniteQueue(1);
    int m_queueTimeoutSec = 5;

    public WCQRunnableImpl(String name) {
        super(name);
        this.setConfigured(false);
    }

    protected WCRequest _dequeueRequest(long timeoutMS) {
        try {
            return this.m_queue.get(timeoutMS);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public void enqueueRequest(WCRequest r) {
        if (r == null) {
            Thread.dumpStack();
        }
        try {
            this.m_queue.put(r);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public void _clientRunCore() throws Exception {
        this.setSubRunLevel("Waiting");
        WCRequest request = this._dequeueRequest((long)this.m_queueTimeoutSec * 1000L);
        if (request == null) {
            this._processTimeout();
            return;
        }
        this.setSubRunLevel("Processing");
        this._processRequest(request);
    }

    protected abstract void _processRequest(WCRequest var1) throws Exception;

    protected void _processTimeout() throws Exception {
        Thread.sleep(100L);
    }

    protected void setQueueSizes(int size) {
        this.m_queue.setCapacity(size);
        this.setConfigured(true);
    }

    protected void setQueueTimeoutSec(int timeoutSec) {
        this.m_queueTimeoutSec = timeoutSec;
    }
}

