/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.sync;

import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FiniteQueue<E> {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + FiniteQueue.class.getName());
    private int capacity;
    private List<E> list;

    public FiniteQueue(int capacity) {
        this.capacity = capacity;
        this.list = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(long timeoutMS) throws InterruptedException {
        long start = System.currentTimeMillis();
        long elapse = 0L;
        List<E> list = this.list;
        synchronized (list) {
            while (!Thread.currentThread().isInterrupted()) {
                if (this.list.size() > 0) {
                    E ret = this.list.remove(0);
                    this.list.notify();
                    if (tracer.isLoggable(Level.FINEST)) {
                        tracer.finest("Dequeued " + ret);
                    }
                    return ret;
                }
                elapse = System.currentTimeMillis() - start;
                if (timeoutMS > 0L) {
                    if (timeoutMS - elapse <= 0L) break;
                    this.list.wait(timeoutMS - elapse);
                    continue;
                }
                this.list.wait();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(E obj) throws InterruptedException {
        while (!Thread.currentThread().isInterrupted()) {
            List<E> list = this.list;
            synchronized (list) {
                if (this.list.size() >= this.capacity) {
                    if (tracer.isLoggable(Level.FINE)) {
                        tracer.fine("Queue is full " + obj);
                    }
                    this.list.wait();
                    continue;
                }
                if (tracer.isLoggable(Level.FINEST)) {
                    tracer.finest("Queued " + obj);
                }
                this.list.add(obj);
                this.list.notify();
                break;
            }
        }
    }

    public int capacity() {
        return this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapacity(int capacity) {
        this.capacity = capacity;
        List<E> list = this.list;
        synchronized (list) {
            this.list.notifyAll();
        }
    }

    public int size() {
        return this.list.size();
    }
}

