/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.storage;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.util.hash.HashableDataBufferOutputStream;
import com.ibm.es.nuvo.crawler.web.db.CrawlRec;
import com.ibm.es.nuvo.crawler.web.http.HTTPCategory;
import com.ibm.es.nuvo.crawler.web.storage.CrawlRecConverter;
import com.ibm.es.nuvo.crawler.web.storage.WebWriter;
import com.ibm.es.nuvo.crawler.web.util.BloomFilter;
import com.ibm.es.nuvo.crawler.web.util.StreamUtils;
import com.ibm.es.nuvo.documentqueue.DeleteDocument;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInsertException;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInterface;
import com.ibm.es.nuvo.documentqueue.StreamedDocument;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.supa.config.AnalysisScopeConfig;
import com.ibm.supa.config.ConfigurationLoader;
import com.ibm.supa.web.WebConfig;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WebWriterImpl
implements WebWriter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + WebWriterImpl.class.getName());
    DocumentQueueInterface queue;
    private int positive;
    private int negative;
    private CrawlRecConverter converter;
    private long[] history = new long[3000];
    private int historyCount;
    private BloomFilter wroteDocs = new BloomFilter(131072, 10);

    public WebWriterImpl(DocumentQueueInterface queue) {
        this.converter = new CrawlRecConverter();
        this.queue = queue;
    }

    public void open() {
    }

    public void close() {
    }

    public boolean write(CrawlRec record) {
        long hash = record.getURL().getURLHash().longValue();
        short oldStatus = record.getOldHTTPStatus();
        HashableDataBufferOutputStream content = record.getContent();
        if (!HTTPCategory.successful(record.getNewHTTPStatus()) || record.isTruncated()) {
            if (content != null) {
                content.dispose();
            }
            if (HTTPCategory.successful(oldStatus) || oldStatus == 0 && this.isLogged(hash)) {
                try {
                    ++this.negative;
                    this.queue.addDocumentStream(record.getConfig().getCollectionId(), new DeleteDocument(record.getURL().downstreamString()));
                }
                catch (DocumentQueueInsertException e) {
                    this.handleException(record, e);
                    return false;
                }
            }
            return true;
        }
        record.recordCrawled();
        StreamedDocument stream = this.converter.convert(record);
        if (stream == null || record.getNewFingerprint() == record.getOldFingerprint() && HTTPCategory.successful(oldStatus)) {
            if (content != null) {
                content.dispose();
            }
            if (stream != null && stream.getInputStream() != null) {
                StreamUtils.safeClose(stream.getInputStream());
            }
            return true;
        }
        try {
            ++this.positive;
            this.logHash(hash);
            AnalysisScopeConfig config = ConfigurationLoader.getAnalysisScopeConfig(record.getConfig().getCollectionId());
            WebConfig webConfig = config.getWebConfig();
            List<String> urlFilters = webConfig.getUrlFilterPatterns();
            String curUrl = record.getURL().downstreamString();
            boolean needToFilter = false;
            if (urlFilters != null) {
                for (String curFilter : urlFilters) {
                    Pattern filterPattern;
                    Matcher m;
                    if (curFilter == null || !(m = (filterPattern = Pattern.compile(curFilter)).matcher(curUrl)).matches()) continue;
                    needToFilter = true;
                    break;
                }
            }
            if (!needToFilter) {
                this.queue.addDocumentStream(record.getConfig().getCollectionId(), stream);
            } else if (content != null) {
                content.dispose();
            }
        }
        catch (DocumentQueueInsertException e) {
            this.handleException(record, e);
            if (content != null) {
                content.dispose();
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLogged(long hash) {
        long[] lArray = this.history;
        synchronized (this.history) {
            if (!this.wroteDocs.contains(hash)) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return false;
            }
            for (int i = 0; i < this.history.length; ++i) {
                if (this.history[i] != hash) continue;
                this.history[i] = 0L;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logHash(long hash) {
        long[] lArray = this.history;
        synchronized (this.history) {
            this.history[this.historyCount++ % this.history.length] = hash;
            this.wroteDocs.add(hash);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    private void handleException(CrawlRec record, DocumentQueueInsertException e) {
        Message message = new Message("C4814E.SAVE_DOCUMENT_FAILED", record.getURL().toString());
        ExtendedException exception = new ExtendedException(message, (Throwable)e);
        if (tracer.isLoggable(Level.FINE)) {
            tracer.log(Level.FINE, exception);
        }
    }

    public void takeSnapshot(StringBuilder builder) {
        builder.append("Writer Status. ");
        builder.append(this.positive);
        builder.append("/");
        builder.append(this.negative);
        builder.append("\n");
    }
}

