/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.storage;

import com.ibm.es.nuvo.crawler.web.util.StreamUtils;
import com.ibm.es.nuvo.documentqueue.BaseDocument;
import com.ibm.es.nuvo.documentqueue.DeleteDocument;
import com.ibm.es.nuvo.documentqueue.DocumentQueue;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInsertException;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInterface;
import com.ibm.es.nuvo.documentqueue.StreamedDocument;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;

public class TeeDocumentQueue
extends DocumentQueue {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private DocumentQueueInterface next;
    private File rootDir;

    public TeeDocumentQueue(int size, DocumentQueueInterface queue, File rootDir) {
        super(size);
        this.next = queue;
        this.rootDir = rootDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocumentStream(String collectionId, BaseDocument document) throws DocumentQueueInsertException {
        block7: {
            File file;
            block8: {
                file = this.getFile(document.getUri());
                if (file == null) break block7;
                if (!(document instanceof StreamedDocument)) break block8;
                file.getParentFile().mkdirs();
                StreamedDocument doc = (StreamedDocument)document;
                InputStream is = null;
                FileOutputStream os = null;
                try {
                    int len;
                    is = doc.getInputStream();
                    os = new FileOutputStream(file);
                    byte[] buffer = new byte[4096];
                    while ((len = is.read(buffer)) > 0) {
                        os.write(buffer, 0, len);
                    }
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        StreamUtils.safeClose(is);
                        StreamUtils.safeClose(os);
                        throw throwable;
                    }
                    StreamUtils.safeClose(is);
                    StreamUtils.safeClose(os);
                    break block7;
                }
                StreamUtils.safeClose(is);
                StreamUtils.safeClose(os);
                break block7;
            }
            if (document instanceof DeleteDocument && file.exists()) {
                file.delete();
            }
        }
        if (this.next != null) {
            this.next.addDocumentStream(collectionId, document);
        }
    }

    private File getFile(String uri) {
        String query;
        URL url;
        StringBuilder builder = new StringBuilder();
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException e) {
            return null;
        }
        builder.append(url.getProtocol());
        builder.append("_");
        builder.append(url.getHost());
        builder.append("_");
        int port = url.getPort();
        if (port < 0) {
            port = url.getProtocol().equals("http") ? 80 : 443;
        }
        builder.append(port);
        String path = url.getPath();
        builder.append(path);
        if (path.endsWith("/")) {
            builder.append("index.html");
        }
        if ((query = url.getQuery()) != null) {
            try {
                builder.append(URLEncoder.encode("?", "utf-8"));
                builder.append(URLEncoder.encode(query, "utf-8"));
            }
            catch (UnsupportedEncodingException ignored) {
                // empty catch block
            }
        }
        File file = new File(this.rootDir, builder.toString());
        return file;
    }
}

