/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.storage;

import com.ibm.es.nuvo.crawler.web.util.StreamUtils;
import com.ibm.es.nuvo.documentqueue.BaseDocument;
import com.ibm.es.nuvo.documentqueue.DataBufferStreamDocument;
import com.ibm.es.nuvo.documentqueue.DeleteDocument;
import com.ibm.es.nuvo.documentqueue.DocumentQueue;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInsertException;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.logging.Level;

public class DebugDocumenQueue
extends DocumentQueue {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static ExtendedLogger logger = Loggers.logger;
    private static boolean show = Boolean.getBoolean("web.show.url");
    private static DebugDocumenQueue instance = new DebugDocumenQueue();
    private PrintStream ps;
    private int count;
    private int totalCount;
    private long last;
    private int lastCount = 0;
    private long start;

    public static DebugDocumenQueue instance() {
        return instance;
    }

    private DebugDocumenQueue() {
        super(1);
        logger.log(Level.SEVERE, "All of crawled documents will be dumped. This is a debug mode.");
        try {
            this.ps = new PrintStream(new FileOutputStream("rdslog.csv"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocumentStream(String collectionId, BaseDocument document) throws DocumentQueueInsertException {
        if (document == null) {
            return;
        }
        ++this.totalCount;
        String uri = document.getUri();
        if (document instanceof DeleteDocument) {
            if (show) {
                System.out.println("- " + uri);
            }
        } else if (document instanceof DataBufferStreamDocument) {
            if (show) {
                System.out.println("+ " + uri);
            }
            ++this.count;
            DataBufferStreamDocument dbsd = (DataBufferStreamDocument)document;
            if (dbsd.getInputStream() != null) {
                StreamUtils.safeClose(dbsd.getInputStream());
            }
            dbsd.dispose();
        } else {
            System.out.println("Unknown document");
        }
        if (this.last == 0L) {
            this.start = this.last = System.currentTimeMillis();
        }
        PrintStream printStream = this.ps;
        synchronized (printStream) {
            if (System.currentTimeMillis() - this.last > 60000L) {
                this.last = System.currentTimeMillis();
                long freeMemory = Runtime.getRuntime().freeMemory();
                long totalMemory = Runtime.getRuntime().totalMemory();
                this.ps.printf("%f,%d,%d,%d,%d\n", (double)(System.currentTimeMillis() - this.start) / 1000.0, this.count, this.count - this.lastCount, freeMemory, totalMemory);
                System.out.printf("%f,%d,%d,%d,%d\n", (double)(System.currentTimeMillis() - this.start) / 1000.0, this.count, this.count - this.lastCount, freeMemory, totalMemory);
                this.lastCount = this.count;
            }
        }
    }

    public void reset() {
        this.lastCount = 0;
        this.count = 0;
        this.totalCount = 0;
        this.start = System.currentTimeMillis();
    }

    public int getTotalCount() {
        return this.totalCount;
    }
}

