/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.storage;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.crawler.util.hash.HashableDataBufferOutputStream;
import com.ibm.es.nuvo.crawler.web.configuration.space.CrawlSpaceConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.KnownInfo;
import com.ibm.es.nuvo.crawler.web.db.CrawlRec;
import com.ibm.es.nuvo.documentqueue.DataBufferStreamDocument;
import com.ibm.es.nuvo.documentqueue.DocumentStreamCreateException;
import com.ibm.es.nuvo.documentqueue.StreamedDocument;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.util.uri.BaseURIUtil;
import java.util.Date;
import java.util.logging.Level;

public class CrawlRecConverter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + CrawlRecConverter.class.getName());

    public StreamedDocument convert(CrawlRec record) {
        HashableDataBufferOutputStream content = record.getContent();
        if (content == null) {
            return null;
        }
        DataBufferStreamDocument document = null;
        try {
            String url = record.getURL().downstreamString();
            document = new DataBufferStreamDocument(url, content);
            Metadata metadata = document.getMetadata();
            this.setMetaData(metadata, "ContentType", record.getContentTypeLC());
            if (record.isHtml()) {
                this.setMetaData(metadata, "KnownContentType", "text/html");
            }
            this.setMetaData(metadata, "Language", record.getContentLanguage());
            this.setMetaData(metadata, "Charset", record.getEncoding());
            long lastModifiedDate = record.getLastModifiedDate();
            lastModifiedDate = lastModifiedDate == 0L ? new Date().getTime() : (lastModifiedDate *= 1000L);
            metadata.set("Date", "" + lastModifiedDate);
            metadata.set("CrawlSpaceID", record.getCrawlerId());
            KnownInfo knownInfo = null;
            try {
                CrawlSpaceConfig config = record.getConfig();
                if (config != null) {
                    knownInfo = config.getKnownInfo(record.getURL());
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            String knownCharset = record.getKnownCharset();
            if (knownInfo != null) {
                this.setMetaData(metadata, "KnownLanguage", knownInfo.getLanguage());
                String knownCodepage = knownInfo.getCodepage();
                this.setMetaData(metadata, "KnownCharset", knownCodepage);
            } else if (knownCharset != null && knownCharset.length() > 0) {
                this.setMetaData(metadata, "KnownCharset", knownCharset);
            }
            String decodedURL = BaseURIUtil.decode(url);
            this.setMetaData(metadata, "URL", decodedURL);
            if (tracer.isLoggable(Level.FINEST)) {
                tracer.finest(metadata.toString());
            }
        }
        catch (DocumentStreamCreateException e) {
            tracer.log(Level.FINE, "", e);
        }
        return document;
    }

    private void setMetaData(Metadata metadata, String name, String value) {
        if (name != null && value != null && metadata != null) {
            metadata.set(name, value);
        }
    }
}

