/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.rule;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;

public class WildcardRule {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String[] patterns;
    private int minLength;
    private boolean startWithWildCard;
    private boolean endWithWildCard;
    private boolean allow;
    private boolean caseSensitive;
    private int matchlength;
    private int lastOffset;

    private WildcardRule(String pattern, boolean allow, boolean caseSensitive) {
        if (!caseSensitive) {
            pattern = pattern.toLowerCase();
        }
        for (String p : this.patterns = this.split(pattern)) {
            this.matchlength += p.length();
        }
        this.startWithWildCard = pattern.startsWith("*");
        this.endWithWildCard = pattern.endsWith("*");
        this.allow = allow;
        this.caseSensitive = caseSensitive;
        this.minLength = 0;
        for (int i = 0; i < this.patterns.length; ++i) {
            this.minLength += this.patterns[i].length();
        }
    }

    private String[] split(String string) {
        int j = 0;
        int i = 0;
        ArrayList<String> list = new ArrayList<String>();
        while ((i = string.indexOf("*", j)) >= 0) {
            if (i > j) {
                list.add(string.substring(j, i));
            }
            j = i + 1;
        }
        if (j < string.length()) {
            list.add(string.substring(j));
        }
        return list.toArray(new String[list.size()]);
    }

    public static WildcardRule compile(String pattern, boolean allow) {
        return WildcardRule.compile(pattern, allow, true);
    }

    public static WildcardRule compile(String pattern, boolean allow, boolean caseSensitive) {
        if (pattern == null || pattern.trim().length() == 0) {
            return null;
        }
        return new WildcardRule(pattern.trim(), allow, caseSensitive);
    }

    public boolean isAllow() {
        return this.allow;
    }

    public boolean matches(String text) {
        int i;
        this.lastOffset = 0;
        if (this.minLength == 0 && this.startWithWildCard) {
            return true;
        }
        if (text == null) {
            return false;
        }
        if (text.length() < this.minLength && this.minLength > 0) {
            return false;
        }
        if (!this.caseSensitive) {
            text = text.toLowerCase();
        }
        int n = this.patterns.length;
        if (!this.endWithWildCard && !this.startWithWildCard && n == 1) {
            this.lastOffset = this.patterns[0].length();
            return this.patterns[0].equals(text);
        }
        if (!this.endWithWildCard && n > 0 && !text.endsWith(this.patterns[n - 1])) {
            return false;
        }
        int j = 0;
        for (i = 0; i < n; ++i) {
            if ((j = text.indexOf(this.patterns[i], j)) < 0 || !this.startWithWildCard && i == 0 && j != 0) {
                return false;
            }
            j += this.patterns[i].length();
        }
        if (i == n && n > 0) {
            j = text.lastIndexOf(this.patterns[n - 1]);
            this.lastOffset = j + this.patterns[n - 1].length();
            return true;
        }
        return false;
    }

    public boolean matches(byte[] content, String encoding) throws IOException {
        ByteArrayInputStream is = null;
        if (content != null) {
            is = new ByteArrayInputStream(content);
        }
        return this.matches(is, encoding);
    }

    public boolean matches(InputStream content, String encoding) throws IOException {
        this.lastOffset = -1;
        if (this.minLength == 0 && this.startWithWildCard) {
            return true;
        }
        if (content == null) {
            return false;
        }
        InputStreamReader reader = new InputStreamReader(content, encoding);
        char[] buffer = new char[1024];
        int length = reader.read(buffer);
        if (length < this.minLength && this.minLength > 0) {
            return false;
        }
        int matchLength = this.patterns[0].length();
        if (!this.endWithWildCard && !this.startWithWildCard && this.patterns.length == 1) {
            StringBuffer sb = new StringBuffer();
            while (length > 0) {
                sb.append(buffer, 0, length);
                if (sb.length() > matchLength) {
                    return false;
                }
                length = reader.read(buffer);
            }
            return this.patterns[0].equals(sb.toString());
        }
        char[] lastWord = null;
        if (!this.endWithWildCard && this.patterns.length > 0) {
            lastWord = new char[this.patterns[this.patterns.length - 1].length()];
            Arrays.fill(lastWord, ' ');
        }
        int patOffset = 0;
        int ixPat = 0;
        int i = 0;
        int count = 0;
        while (length > 0) {
            if (ixPat < this.patterns.length) {
                for (i = 0; i < length; ++i) {
                    ++count;
                    char c = buffer[i];
                    if (c == this.patterns[ixPat].charAt(patOffset)) {
                        if (this.patterns[ixPat].length() != ++patOffset) continue;
                        if (ixPat == 0 && !this.startWithWildCard && count != this.patterns[ixPat].length()) {
                            return false;
                        }
                        if (++ixPat == this.patterns.length) break;
                    }
                    patOffset = 0;
                }
            }
            if (lastWord != null) {
                int moveLen = lastWord.length - length;
                if (moveLen > 0) {
                    System.arraycopy(lastWord, length, lastWord, 0, moveLen);
                    System.arraycopy(buffer, 0, lastWord, moveLen, length);
                } else {
                    System.arraycopy(buffer, -moveLen, lastWord, 0, lastWord.length);
                }
            }
            length = reader.read(buffer);
        }
        if (ixPat < this.patterns.length && this.patterns[ixPat].length() == patOffset) {
            ++ixPat;
        }
        if (lastWord != null && !this.patterns[this.patterns.length - 1].equals(new String(lastWord))) {
            return false;
        }
        return ixPat == this.patterns.length;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.startWithWildCard) {
            buffer.append("*");
        }
        for (int i = 0; i < this.patterns.length; ++i) {
            if (i > 0) {
                buffer.append("*");
            }
            buffer.append(this.patterns[i]);
        }
        if (this.endWithWildCard && this.patterns.length > 0) {
            buffer.append("*");
        }
        return buffer.toString();
    }

    public int getMatchlength() {
        return this.matchlength;
    }

    public int getLastOffset() {
        if (this.lastOffset < 0) {
            throw new UnsupportedOperationException("This operation is not supported for streaming");
        }
        return this.lastOffset;
    }
}

