/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.rule;

import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.bucket.Bucket;
import com.ibm.es.nuvo.crawler.web.config.InvalidRuleException;
import com.ibm.es.nuvo.crawler.web.configuration.space.RuleEntry;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.crawler.web.rule.AddressRule;
import com.ibm.es.nuvo.crawler.web.rule.DomainRule;
import com.ibm.es.nuvo.crawler.web.rule.RobotsRule;
import com.ibm.es.nuvo.crawler.web.rule.WSConstants;
import com.ibm.es.nuvo.crawler.web.rule.WildcardRule;
import com.ibm.es.nuvo.crawler.web.util.BloomFilter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSpace
implements WSConstants {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private BloomFilter disallowedBuckets = new BloomFilter(4096, 10);
    private int m_defaultSense;
    private ArrayList<String> excluses = new ArrayList();
    private ArrayList<DomainRule> m_domainRules = new ArrayList();
    private ArrayList<AddressRule> m_addressRules = new ArrayList();
    private ArrayList<WildcardRule> prefixRule = new ArrayList();

    public WebSpace(int defaultSense) {
        this.m_defaultSense = defaultSense;
    }

    public boolean isAllowed(CURL url) {
        int max = 0;
        int offset = 0;
        WildcardRule ret = null;
        int baseLength = url.toString().length();
        int hostLength = (url.getProtocol() + "://" + url.getHostname()).length();
        for (String urlString : new String[]{url.toString(), url.downstreamString()}) {
            int baseOffset = baseLength - urlString.length();
            for (WildcardRule rule : this.prefixRule) {
                if (!rule.matches(urlString)) continue;
                int lastOffset = rule.getLastOffset();
                if (baseOffset != 0 && lastOffset > hostLength) {
                    lastOffset += baseOffset;
                }
                int matchlength = rule.getMatchlength();
                if (lastOffset <= offset && (lastOffset != offset || max > matchlength)) continue;
                boolean allow = rule.isAllow();
                if (offset == lastOffset && max == matchlength) {
                    if (!allow) {
                        ret = rule;
                    }
                } else {
                    ret = rule;
                }
                max = matchlength;
                offset = lastOffset;
            }
        }
        return ret != null ? ret.isAllow() : this.m_defaultSense == 1;
    }

    public boolean isAllowed(InetAddress ia) {
        byte[] ba = ia.getAddress();
        for (AddressRule ar : this.m_addressRules) {
            int outcome = ar.test(ba);
            if (outcome == 0) continue;
            return outcome == 1;
        }
        return this.m_defaultSense == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAllowed(Bucket bucket) {
        int protocolNumber = bucket.getProtocolNumber();
        int portNumber = bucket.getPort();
        boolean allowed = this.isAllowed(bucket.getHostname(), protocolNumber, portNumber);
        if (!allowed) {
            BloomFilter bloomFilter = this.disallowedBuckets;
            synchronized (bloomFilter) {
                this.disallowedBuckets.add(bucket.getHostHash().longValue());
            }
        }
        return allowed;
    }

    public boolean isAllowed(String hostname, int protocolNumber, int portNumber) {
        boolean allowed = this.m_defaultSense == 1;
        for (DomainRule dr : this.m_domainRules) {
            int outcome = dr.test(protocolNumber, hostname, portNumber);
            if (outcome == 0) continue;
            allowed = outcome == 1;
            break;
        }
        return allowed;
    }

    public boolean isExcluded(CURL url) {
        if (this.excluses.size() == 0) {
            return false;
        }
        String path = url.getPath().toLowerCase();
        for (String suffix : this.excluses) {
            if (!path.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public void configure(List<RuleEntry> rules) throws InvalidRuleException {
        this.m_domainRules.clear();
        this.m_addressRules.clear();
        this.prefixRule.clear();
        for (RuleEntry entry : rules) {
            int sense = entry.isAllow() ? 1 : -1;
            String pattern = entry.getPattern();
            if (pattern == null) {
                throw new InvalidRuleException("Pattern was null", null);
            }
            switch (entry.getType()) {
                case ADDRESS: {
                    this.m_addressRules.add(new AddressRule(sense, pattern));
                    break;
                }
                case DOMAIN: {
                    this.m_domainRules.add(new DomainRule(sense, pattern));
                    break;
                }
                case PREFIX: {
                    WildcardRule rule = WildcardRule.compile(pattern, entry.isAllow());
                    if (rule == null) break;
                    this.prefixRule.add(rule);
                }
            }
        }
    }

    public void setExcludePattern(String pattern) {
        if (pattern != null) {
            String string = pattern.replaceAll("\\\\.", "").toLowerCase();
            StringTokenizer tokenizer = new StringTokenizer(string, "|");
            this.excluses.clear();
            this.excluses.ensureCapacity(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                this.excluses.add(tokenizer.nextToken());
            }
        } else {
            this.excluses.clear();
        }
    }

    public boolean robotsExcludes(RobotsRule[] rules, CURL url) {
        int result;
        int j;
        if (rules == null || rules.length == 0 || url == null) {
            return false;
        }
        String path = url.getPath();
        for (j = 0; j < rules.length; ++j) {
            result = rules[j].test(path);
            if (result == 0) continue;
            return result == -1;
        }
        path = url.getOriginalPath();
        if (path != null) {
            for (j = 0; j < rules.length; ++j) {
                result = rules[j].test(path);
                if (result == 0) continue;
                return result == -1;
            }
        }
        return false;
    }

    public boolean isAlreadyDisallowedBucket(Hash64 hostHash) {
        if (hostHash == null) {
            return false;
        }
        return this.disallowedBuckets.contains(hostHash.longValue()) && this.disallowedBuckets.canTrust();
    }
}

