/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.rule;

import com.ibm.es.nuvo.crawler.web.rule.RobotsRule;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;

public class RobotsTxtParser {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + RobotsTxtParser.class.getName());
    private static final String SEPARATOR = ":";
    private static final String KEY_AGENT = "User-agent";
    private static final String KEY_DISALLOW = "Disallow";
    private static final String KEY_ALLOW = "Allow";
    private static final char DISALLOW_MARK = 'D';
    private static final char ALLOW_MARK = 'A';

    static String parseRaw(String reader, String agentName) {
        return RobotsTxtParser.parseRaw(new StringReader(reader), agentName);
    }

    public static String parseRaw(Reader srcReader, String agentName) {
        if (srcReader == null) {
            return null;
        }
        boolean hasOwn = false;
        boolean needLine = false;
        BufferedReader reader = new BufferedReader(srcReader);
        String lastKey = null;
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                int i = (line = line.trim()).indexOf("#");
                if (i > 0) {
                    line = line.substring(0, i).trim();
                } else if (i == 0) continue;
                if (line.length() == 0 || (i = line.indexOf(SEPARATOR)) < 0) continue;
                String key = line.substring(0, i).trim();
                String value = line.substring(i + 1).trim();
                if (KEY_DISALLOW.equalsIgnoreCase(key)) {
                    if (needLine) {
                        if (buffer.length() > 0) {
                            buffer.append(SEPARATOR);
                        }
                        buffer.append('D');
                        buffer.append(value);
                    }
                } else if (KEY_AGENT.equalsIgnoreCase(key)) {
                    if (value.equals("*")) {
                        if (hasOwn) break;
                        needLine = true;
                    } else if (agentName != null && value != null && agentName.regionMatches(true, 0, value, 0, value.length() - (value.endsWith("*") ? 1 : 0))) {
                        buffer = new StringBuffer();
                        hasOwn = true;
                        needLine = true;
                    } else if (!KEY_AGENT.equalsIgnoreCase(lastKey)) {
                        needLine = false;
                    }
                } else if (KEY_ALLOW.equalsIgnoreCase(key) && needLine) {
                    if (buffer.length() > 0) {
                        buffer.append(SEPARATOR);
                    }
                    buffer.append('A');
                    buffer.append(value);
                }
                lastKey = key;
            }
        }
        catch (Exception e) {
            tracer.log(Level.FINE, "", e);
        }
        return buffer.toString();
    }

    public static RobotsRule[] createRules(String parsedText) {
        if (parsedText == null) {
            return null;
        }
        String[] keys = parsedText.split(SEPARATOR);
        ArrayList<RobotsRule> list = new ArrayList<RobotsRule>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].length() == 0) continue;
            char c = keys[i].charAt(0);
            if ('D' == c) {
                list.add(new RobotsRule(-1, keys[i].substring(1)));
                continue;
            }
            if ('A' != c) continue;
            list.add(new RobotsRule(1, keys[i].substring(1)));
        }
        if (list.size() == 0) {
            return null;
        }
        if (list.size() > 1) {
            try {
                Collections.sort(list, new LengthComparator());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list.toArray(new RobotsRule[list.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LengthComparator
    implements Comparator<RobotsRule>,
    Serializable {
        private static final long serialVersionUID = 1168834413164942000L;

        private LengthComparator() {
        }

        @Override
        public int compare(RobotsRule o1, RobotsRule o2) {
            if (o1 == o2 || o1 == null || o2 == null) {
                return 0;
            }
            return o2.toString().length() - o1.toString().length();
        }
    }
}

