/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.rule;

import com.ibm.es.nuvo.crawler.web.config.InvalidRuleArgCountException;
import com.ibm.es.nuvo.crawler.web.config.InvalidRuleException;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.net.IPProto;
import com.ibm.es.nuvo.crawler.web.rule.AbstractRule;
import com.ibm.es.nuvo.crawler.web.rule.WildcardRule;

public class DomainRule
extends AbstractRule {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    WildcardRule rule;
    String domain;
    int port;
    String protocol;

    DomainRule(int sense, String[] parsedText, String originalText) throws WCException {
        super(sense);
        if (parsedText == null || parsedText.length != 3) {
            throw new InvalidRuleArgCountException("prefix", 3, parsedText == null ? 0 : parsedText.length, "");
        }
        this.parse(parsedText[2]);
    }

    public DomainRule(int sense, String pattern) throws InvalidRuleException {
        super(sense);
        this.parse(pattern);
    }

    public int test(int protocolNumber, String hostname, int portNo) {
        if (hostname == null) {
            return 0;
        }
        if (this.rule != null) {
            StringBuffer entryString = new StringBuffer(64);
            entryString.append(IPProto.getProtocolName(protocolNumber));
            entryString.append("://");
            entryString.append(hostname);
            entryString.append(":");
            entryString.append(portNo);
            String entryURL = entryString.toString();
            if (this.rule.matches(entryURL)) {
                return this.m_sense;
            }
        } else if (hostname.equals(this.domain) && (this.protocol == null || this.protocol.equalsIgnoreCase(IPProto.getProtocolName(protocolNumber))) && (this.port == 0 || this.port == portNo)) {
            return this.m_sense;
        }
        return 0;
    }

    protected void parse(String parsedText) throws InvalidRuleException {
        String key = parsedText;
        int iProtocol = key.indexOf("://");
        int iPort = key.lastIndexOf(58);
        if (iPort == iProtocol) {
            iPort = -1;
        }
        if (key.indexOf("*") >= 0) {
            if (iProtocol == -1 && iPort == -1) {
                key = "*://" + key + ":*";
            } else if (iProtocol == -1 && iPort > -1) {
                key = "*://" + key;
            } else if (iProtocol > -1 && iPort > -1) {
                String proto = key.substring(0, iProtocol);
                if (iProtocol < iPort) {
                    if (!proto.equalsIgnoreCase("http") && !proto.equalsIgnoreCase("https")) {
                        throw new InvalidRuleException("domain", proto);
                    }
                } else if (proto.equalsIgnoreCase("http") || proto.equalsIgnoreCase("https")) {
                    key = key + ":*";
                } else {
                    throw new InvalidRuleException("domain", proto);
                }
            }
            this.rule = WildcardRule.compile(key, this.m_sense == 1);
        } else {
            int start = 0;
            int end = key.length();
            if (iProtocol > 0) {
                start = iProtocol + 3;
                this.protocol = key.substring(0, iProtocol);
            }
            if (iPort > 0 && iPort > iProtocol && iPort < end - 1) {
                this.port = Integer.parseInt(key.substring(iPort));
                end = iPort;
            }
            if (start < end) {
                this.domain = key.substring(start, end);
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.m_sense == 1 ? "Allow " : "Disallow ");
        if (this.rule != null) {
            buffer.append(this.rule);
        } else {
            if (this.protocol == null) {
                buffer.append(this.protocol);
            } else {
                buffer.append("*");
            }
            buffer.append("://");
            buffer.append(this.domain);
            buffer.append(":");
            if (this.port != 0) {
                buffer.append(this.port);
            } else {
                buffer.append("*");
            }
        }
        return buffer.toString();
    }
}

