/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.rule;

import com.ibm.es.nuvo.crawler.web.config.InvalidRuleArgCountException;
import com.ibm.es.nuvo.crawler.web.config.InvalidRuleException;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.rule.AbstractRule;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public class AddressRule
extends AbstractRule {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    byte[] m_address;
    byte[] m_mask;

    public AddressRule(int sense, String[] parsedText, String originalText) throws WCException {
        super(sense);
        this.parse(parsedText);
    }

    public AddressRule(int sense, String pattern) throws InvalidRuleException {
        super(sense);
        int idx = pattern.indexOf("/");
        try {
            if (idx < 0) {
                this.m_address = InetAddress.getByName(pattern).getAddress();
                this.m_mask = new byte[this.m_address.length];
                Arrays.fill(this.m_mask, (byte)-1);
            } else {
                this.m_address = InetAddress.getByName(pattern.substring(0, idx)).getAddress();
                this.m_mask = InetAddress.getByName(pattern.substring(idx + 1)).getAddress();
            }
        }
        catch (UnknownHostException e) {
            throw new InvalidRuleException("address", "", e);
        }
    }

    private void parse(String[] parsedText) throws InvalidRuleException {
        try {
            if (parsedText == null || parsedText.length != 4) {
                throw new InvalidRuleArgCountException("address", 4, parsedText == null ? 0 : parsedText.length, "");
            }
            this.m_address = InetAddress.getByName(parsedText[2]).getAddress();
            this.m_mask = InetAddress.getByName(parsedText[3]).getAddress();
        }
        catch (Exception e) {
            throw new InvalidRuleException("address", "", e);
        }
    }

    public int test(byte[] address) {
        if (address == null) {
            return 0;
        }
        int length = address.length;
        if (length != this.m_address.length) {
            return 0;
        }
        for (int j = 0; j < length; ++j) {
            if (((this.m_address[j] ^ address[j]) & this.m_mask[j]) == 0) continue;
            return 0;
        }
        return this.m_sense;
    }

    public String toString() {
        int k;
        int j;
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (j = 0; j < this.m_address.length; ++j) {
            if (j > 0) {
                sb.append(".");
            }
            sb.append((k = this.m_address[j]) < 0 ? k + 256 : k);
        }
        sb.append("] ");
        sb.append("[");
        for (j = 0; j < this.m_mask.length; ++j) {
            if (j > 0) {
                sb.append(".");
            }
            sb.append((k = this.m_mask[j]) < 0 ? k + 256 : k);
        }
        sb.append("] ");
        return sb.toString();
    }

    public byte[] getBytes() {
        byte[] retAddress = new byte[this.m_address.length];
        System.arraycopy(this.m_address, 0, retAddress, 0, this.m_address.length);
        return retAddress;
    }
}

