/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.plugin;

import com.ibm.es.nuvo.crawler.util.hash.HashableDataBufferOutputStream;
import com.ibm.es.nuvo.crawler.web.db.CrawlRec;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.crawler.web.util.StreamUtils;
import com.ibm.es.nuvo.util.databuffer.DataBufferException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class WebPage {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private CrawlRec rec;
    private HashableDataBufferOutputStream stream;
    private List<InputStream> streams = new ArrayList<InputStream>();

    WebPage(CrawlRec rec) {
        this.rec = rec;
    }

    public String getURL() {
        return this.rec.getURL().downstreamString();
    }

    public Properties getHeader() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.rec.getHeaderProperties());
        return properties;
    }

    public void addLink(URL url) {
        CURL curl = new CURL(url.toString());
        if (curl.isValid()) {
            this.rec.getOutLinks().add(curl);
        }
    }

    public OutputStream getModifiedContentStream() {
        this.cancelContentModification();
        this.stream = new HashableDataBufferOutputStream();
        return this.stream;
    }

    public void cancelContentModification() {
        if (this.stream != null) {
            StreamUtils.safeClose(this.stream);
            this.stream.dispose();
            this.stream = null;
        }
    }

    public InputStream getContentAsStream() {
        InputStream contentStream = null;
        try {
            HashableDataBufferOutputStream content = this.rec.getContent();
            if (content != null && (contentStream = content.getInputStream()) != null) {
                this.streams.add(contentStream);
            }
        }
        catch (DataBufferException e) {
            e.printStackTrace();
        }
        return contentStream;
    }

    void close() {
        if (this.stream != null) {
            StreamUtils.safeClose(this.stream);
            HashableDataBufferOutputStream content = this.rec.getContent();
            if (content != null) {
                content.dispose();
            }
            this.rec.setContent(this.stream);
        }
        for (InputStream is : this.streams) {
            StreamUtils.safeClose(is);
        }
    }
}

