/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.plugin;

import com.ibm.es.nuvo.crawler.web.db.CrawlRec;
import com.ibm.es.nuvo.crawler.web.plugin.WebCrawlerPlugin;
import com.ibm.es.nuvo.crawler.web.plugin.WebPage;
import com.ibm.es.nuvo.crawler.web.util.StreamUtils;
import com.ibm.es.nuvo.util.databuffer.DataBufferException;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginHandler {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final PluginHandler instance = new PluginHandler();

    public static PluginHandler getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(CrawlRec rec, List<WebCrawlerPlugin> plugins) {
        WebPage page = new WebPage(rec);
        if (rec.getContent() == null) {
            return;
        }
        InputStream is = null;
        try {
            is = rec.getContent().getInputStream();
        }
        catch (DataBufferException e) {
            // empty catch block
        }
        if (is == null) {
            return;
        }
        StreamUtils.safeClose(is);
        try {
            for (WebCrawlerPlugin plugin : plugins) {
                plugin.process(page);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            page.cancelContentModification();
        }
        finally {
            page.close();
        }
    }
}

