/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.parser.html.stream;

import com.ibm.es.nuvo.crawler.web.parser.doc.Field;
import com.ibm.es.nuvo.crawler.web.parser.html.stream.AttributeEntry;
import com.ibm.es.nuvo.crawler.web.parser.html.stream.AttributeHandler;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaHandler
extends AttributeHandler {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    static final String DC_DATE = "dc.date";
    private static final ExtendedLogger tracer;
    private static final String[] DATE_PATTERNS;
    private static SimpleDateFormat[] simpleDateFormat;
    private static int maxDateLength;
    static final String CHARSET = "charset";
    private static final String NAME = "name";
    static final String ROBOTS = "robots";
    private static final String CONTENT = "content";
    private static final String HTTP_EQUIV = "http-equiv";
    static final String CONETNT_TYPE = "content-type";
    static final String SOFT_REDIRECT = "refresh";
    private static final List<String> NEED_ATTRS;

    public static void parse(Properties properties, List<Field> fields, String text) {
        int i;
        AttributeEntry[] entries = MetaHandler.parse(text, NEED_ATTRS);
        String key = null;
        String value = null;
        boolean named = false;
        for (i = 0; i < entries.length; ++i) {
            if (HTTP_EQUIV.equalsIgnoreCase(entries[i].getName())) {
                if (CONETNT_TYPE.equalsIgnoreCase(entries[i].getValue())) {
                    key = entries[i].getValue();
                    continue;
                }
                if (!SOFT_REDIRECT.equalsIgnoreCase(entries[i].getValue())) continue;
                key = entries[i].getValue();
                continue;
            }
            if (NAME.equals(entries[i].getName())) {
                key = entries[i].getValue();
                named = true;
                continue;
            }
            if (!CONTENT.equalsIgnoreCase(entries[i].getName())) continue;
            value = entries[i].getValue();
        }
        if (key != null && value != null) {
            if (key.equalsIgnoreCase(CONETNT_TYPE)) {
                StringTokenizer tokenizer = new StringTokenizer(value, ";");
                i = 0;
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken().trim();
                    if (i == 0) {
                        properties.put(CONETNT_TYPE, token);
                    } else {
                        int idx = token.indexOf("=");
                        if (idx > 0) {
                            String typeName = token.substring(0, idx);
                            String typeValue = token.substring(idx + 1);
                            if (CHARSET.equalsIgnoreCase(typeName)) {
                                properties.put(CHARSET, typeValue);
                            }
                        }
                    }
                    ++i;
                }
            } else if (key.equalsIgnoreCase(SOFT_REDIRECT)) {
                StringTokenizer tokenizer = new StringTokenizer(value, ";");
                i = 0;
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken().trim();
                    int j = token.indexOf("=");
                    if (i == 1 && j > 0 && token.substring(0, j).trim().toLowerCase().startsWith("url")) {
                        String link = token.substring(j + 1).trim();
                        properties.put(SOFT_REDIRECT, link);
                    }
                    ++i;
                }
            } else if (named) {
                if (DC_DATE.equalsIgnoreCase(key)) {
                    Date date;
                    int j;
                    for (j = 0; j < value.length() && !Character.isDigit(value.charAt(j)); ++j) {
                    }
                    if (j > 0) {
                        value = value.substring(j);
                    }
                    if ((date = MetaHandler.parseDate(value)) != null) {
                        properties.put(key, date);
                    } else if (tracer.isLoggable(Level.FINE)) {
                        tracer.log(Level.FINE, "Unable to parse DC_DATE from \"" + value + "\".");
                    }
                } else {
                    fields.add(new Field(key, value));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String dateStr) {
        Date result = null;
        if (dateStr == null || dateStr.length() < 4 || maxDateLength < dateStr.length()) {
            return null;
        }
        SimpleDateFormat[] arr$ = simpleDateFormat;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            SimpleDateFormat format;
            SimpleDateFormat simpleDateFormat = format = arr$[i$];
            synchronized (simpleDateFormat) {
                result = MetaHandler.tryToParse(dateStr, format);
                if (result != null) {
                    break;
                }
                continue;
            }
        }
        return result;
    }

    private static Date tryToParse(String str, SimpleDateFormat pattern) {
        try {
            return pattern.parse(str);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        int i;
        tracer = ExtendedLogger.getLogger("NuvoTracer." + MetaHandler.class.getName());
        DATE_PATTERNS = new String[]{"yyyy-MM-dd", "yyyy-MM", "yyyy", "yyyy-MM-dd'T'hh:mmZ", "yyyy-MM-dd'T'hh:mm:ssZ", "yyyy-MM-dd'T'hh:mm:ss.ssZ", "MM/dd/yyyy", "MM/dd/yyyy hh:mm:ss a", "EEE, dd MMM yyyy HH:mm:ss z", "EEE, dd-MMM-yyyy HH:mm:ss z"};
        simpleDateFormat = new SimpleDateFormat[DATE_PATTERNS.length * 2];
        for (i = 0; i < DATE_PATTERNS.length; ++i) {
            MetaHandler.simpleDateFormat[i] = new SimpleDateFormat(DATE_PATTERNS[i], Locale.ENGLISH);
            maxDateLength = maxDateLength > DATE_PATTERNS[i].length() ? maxDateLength : DATE_PATTERNS[i].length();
        }
        for (i = 0; i < DATE_PATTERNS.length; ++i) {
            MetaHandler.simpleDateFormat[i + MetaHandler.DATE_PATTERNS.length] = new SimpleDateFormat(DATE_PATTERNS[i]);
            maxDateLength = maxDateLength > DATE_PATTERNS[i].length() ? maxDateLength : DATE_PATTERNS[i].length();
        }
        maxDateLength += 2;
        NEED_ATTRS = Arrays.asList(NAME, HTTP_EQUIV, CONTENT);
    }
}

