/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.parser.html.stream;

import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.crawler.web.parser.doc.Link;
import com.ibm.es.nuvo.crawler.web.parser.html.stream.AttributeEntry;
import com.ibm.es.nuvo.crawler.web.parser.html.stream.AttributeHandler;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkHandler
extends AttributeHandler {
    private static final boolean DECODED_URI_ONLY = false;
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final List<String> NEED_ATTRIBUTES = Arrays.asList("href", "rel", "type");
    private static final String PREDEFINED = "lt;gt;amp;apos;quot;";
    private static final String[][] PREDEFINED_ENTITIES = new String[][]{{"lt;", "%3C"}, {"gt;", "%3E"}, {"amp", "&"}, {"apos", "%27"}, {"quot", "%22"}};
    private static final String UNRESERVED = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()";
    private static final String PCHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'():@&=+$,";

    public static void parse(List<Link> links, String text, boolean isAtom) {
        AttributeEntry[] entries = LinkHandler.parse(text, NEED_ATTRIBUTES);
        boolean follow = true;
        String linkFragment = null;
        boolean atomDiscard = false;
        for (int i = 0; i < entries.length; ++i) {
            String name = entries[i].getName();
            String value = entries[i].getValue();
            if ("href".equalsIgnoreCase(name)) {
                int segIdx;
                if (value.startsWith("javascript:") || (segIdx = value.indexOf("#")) == 0) continue;
                if (segIdx > 0) {
                    value = value.substring(0, segIdx);
                }
                linkFragment = value;
                continue;
            }
            if ("rel".equalsIgnoreCase(name)) {
                if (!"nofollow".equalsIgnoreCase(value)) continue;
                follow = false;
                continue;
            }
            if (!isAtom || !"type".equalsIgnoreCase(name) || !"application/atom+xml".equalsIgnoreCase(value)) continue;
            atomDiscard = true;
        }
        if (linkFragment != null && !atomDiscard) {
            String alterLinkStr = LinkHandler.decodeLinkStr(linkFragment);
            if (alterLinkStr != null) {
                links.add(new Link(alterLinkStr, follow));
            }
            links.add(new Link(linkFragment, follow));
        }
    }

    public static CURL parseBase(String tag) {
        AttributeEntry[] entries = LinkHandler.parse(tag, NEED_ATTRIBUTES);
        CURL base = null;
        for (AttributeEntry entry : entries) {
            if (!"href".equalsIgnoreCase(entry.getName()) || (base = new CURL(entry.getValue())).isValid()) continue;
            base = null;
        }
        return base;
    }

    private static String decodeLinkStr(String linkFragment) {
        int j;
        if (linkFragment == null || !linkFragment.contains("&") || !linkFragment.contains(";")) {
            return null;
        }
        int i = linkFragment.indexOf("&");
        int last = 0;
        StringBuilder builder = new StringBuilder();
        boolean hasEncodedPart = false;
        while (i >= 0 && (j = linkFragment.indexOf(";", i)) >= 0) {
            if (last < i) {
                builder.append(linkFragment.substring(last, i));
            }
            last = j + 1;
            String value = linkFragment.substring(i + 1, j);
            boolean decoded = false;
            if (value.length() >= 2) {
                if (value.charAt(0) == '#') {
                    int base = 10;
                    if (value.charAt(1) == 'x') {
                        value = value.substring(2);
                        base = 16;
                    } else {
                        value = value.substring(1);
                    }
                    try {
                        long l = Long.parseLong(value, base);
                        if (l > 0L && l < 256L) {
                            char v = (char)l;
                            if (PCHAR.indexOf(v) >= 0) {
                                builder.append(v);
                            } else {
                                try {
                                    builder.append(URLEncoder.encode("" + v, "utf-8"));
                                }
                                catch (UnsupportedEncodingException ignored) {}
                            }
                        } else {
                            String hs = Long.toHexString(l).toUpperCase();
                            if (hs.length() % 2 != 0) {
                                hs = "0" + hs;
                            }
                            for (int o = 0; o < hs.length(); o += 2) {
                                builder.append("%").append(hs.substring(o, o + 2));
                            }
                        }
                        decoded = true;
                    }
                    catch (NumberFormatException ignored) {}
                } else if (PREDEFINED.contains(value)) {
                    for (String[] ss : PREDEFINED_ENTITIES) {
                        if (!ss[0].equals(value)) continue;
                        builder.append(ss[1]);
                        decoded = true;
                        break;
                    }
                }
            }
            if (!decoded) {
                builder.append("&").append(value).append(";");
            }
            i = linkFragment.indexOf("&", j);
            if (!decoded) continue;
            hasEncodedPart = true;
        }
        if (last < linkFragment.length()) {
            builder.append(linkFragment.substring(last));
        }
        return hasEncodedPart ? builder.toString() : null;
    }
}

