/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.parser.html;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTMLEntities {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    static int MAX_ESC = 7;
    static HashMap<String, Character> escapes = new HashMap(150);
    static Pattern entityPattern = Pattern.compile("&(#(\\d+)|([a-zA-Z]+));");

    public static int replaceOneEntity(String in, int from, int to, StringBuffer out) {
        int p = from + 1;
        if (p < to && in.charAt(p) == '#') {
            int q;
            char replace = '\u0000';
            for (q = p + 1; q < to && in.charAt(q) != ';'; ++q) {
                if (!Character.isDigit(in.charAt(q))) {
                    replace = '\u0000';
                    break;
                }
                replace = (char)(replace * 10 + in.charAt(q) - 48);
            }
            if (replace != '\u0000') {
                if (out != null) {
                    out.append(replace);
                }
                return q + 1;
            }
        } else {
            String escSeq;
            Character newChar;
            int q;
            for (q = p; q - p < MAX_ESC && q < to && in.charAt(q) != ';'; ++q) {
            }
            if (q > p && q < to && in.charAt(q) == ';' && (newChar = escapes.get(escSeq = in.substring(p, q))) != null) {
                if (out != null) {
                    out.append(newChar.charValue());
                }
                return q + 1;
            }
        }
        if (out != null) {
            out.append(in.charAt(from));
        }
        return p;
    }

    public static String decodeHTMLEncoding(String str) {
        try {
            Matcher matcher = entityPattern.matcher(str);
            if (matcher.find()) {
                StringBuffer result = new StringBuffer();
                int p = 0;
                int to = str.length();
                while (p < to) {
                    if (str.charAt(p) == '&') {
                        p = HTMLEntities.replaceOneEntity(str, p, to, result);
                        continue;
                    }
                    result.append(str.charAt(p));
                    ++p;
                }
                return result.toString();
            }
        }
        catch (Exception e) {
            return str;
        }
        return str;
    }

    static {
        escapes.put("quot", Character.valueOf('\"'));
        escapes.put("amp", Character.valueOf('&'));
        escapes.put("lt", Character.valueOf('<'));
        escapes.put("gt", Character.valueOf('>'));
        escapes.put("nbsp", Character.valueOf(' '));
        escapes.put("ensp", Character.valueOf(' '));
        escapes.put("emsp", Character.valueOf(' '));
        escapes.put("ndash", Character.valueOf('-'));
        escapes.put("frasl", Character.valueOf('/'));
        escapes.put("mdash", Character.valueOf('\u0097'));
        escapes.put("iexcl", Character.valueOf('\u00a1'));
        escapes.put("cent", Character.valueOf('\u00a2'));
        escapes.put("pound", Character.valueOf('\u00a3'));
        escapes.put("curren", Character.valueOf('\u00a4'));
        escapes.put("yen", Character.valueOf('\u00a5'));
        escapes.put("brvbar", Character.valueOf('\u00a6'));
        escapes.put("sect", Character.valueOf('\u00a7'));
        escapes.put("uml", Character.valueOf('\u00a8'));
        escapes.put("copy", Character.valueOf('\u00a9'));
        escapes.put("ordf", Character.valueOf('\u00aa'));
        escapes.put("laquo", Character.valueOf('\u00ab'));
        escapes.put("not", Character.valueOf('\u00ac'));
        escapes.put("shy", Character.valueOf('\u00ad'));
        escapes.put("reg", Character.valueOf('\u00ae'));
        escapes.put("macr", Character.valueOf('\u00af'));
        escapes.put("deg", Character.valueOf('\u00b0'));
        escapes.put("plusmn", Character.valueOf('\u00b1'));
        escapes.put("sup2", Character.valueOf('\u00b2'));
        escapes.put("sup3", Character.valueOf('\u00b3'));
        escapes.put("acute", Character.valueOf('\u00b4'));
        escapes.put("micro", Character.valueOf('\u00b5'));
        escapes.put("para", Character.valueOf('\u00b6'));
        escapes.put("middot", Character.valueOf('\u00b7'));
        escapes.put("cedil", Character.valueOf('\u00b8'));
        escapes.put("sup1", Character.valueOf('\u00b9'));
        escapes.put("ordm", Character.valueOf('\u00ba'));
        escapes.put("raquo", Character.valueOf('\u00bb'));
        escapes.put("frac14", Character.valueOf('\u00bc'));
        escapes.put("frac12", Character.valueOf('\u00bd'));
        escapes.put("frac34", Character.valueOf('\u00be'));
        escapes.put("iquest", Character.valueOf('\u00bf'));
        escapes.put("Agrave", Character.valueOf('\u00c0'));
        escapes.put("Aacute", Character.valueOf('\u00c1'));
        escapes.put("Acirc", Character.valueOf('\u00c2'));
        escapes.put("Atilde", Character.valueOf('\u00c3'));
        escapes.put("Auml", Character.valueOf('\u00c4'));
        escapes.put("Aring", Character.valueOf('\u00c5'));
        escapes.put("AElig", Character.valueOf('\u00c6'));
        escapes.put("Ccedil", Character.valueOf('\u00c7'));
        escapes.put("Egrave", Character.valueOf('\u00c8'));
        escapes.put("Eacute", Character.valueOf('\u00c9'));
        escapes.put("Ecirc", Character.valueOf('\u00ca'));
        escapes.put("Euml", Character.valueOf('\u00cb'));
        escapes.put("Igrave", Character.valueOf('\u00cc'));
        escapes.put("Iacute", Character.valueOf('\u00cd'));
        escapes.put("Icirc", Character.valueOf('\u00ce'));
        escapes.put("Iuml", Character.valueOf('\u00cf'));
        escapes.put("ETH", Character.valueOf('\u00d0'));
        escapes.put("Ntilde", Character.valueOf('\u00d1'));
        escapes.put("Ograve", Character.valueOf('\u00d2'));
        escapes.put("Oacute", Character.valueOf('\u00d3'));
        escapes.put("Ocirc", Character.valueOf('\u00d4'));
        escapes.put("Otilde", Character.valueOf('\u00d5'));
        escapes.put("Ouml", Character.valueOf('\u00d6'));
        escapes.put("times", Character.valueOf('\u00d7'));
        escapes.put("Oslash", Character.valueOf('\u00d8'));
        escapes.put("Ugrave", Character.valueOf('\u00d9'));
        escapes.put("Uacute", Character.valueOf('\u00da'));
        escapes.put("Ucirc", Character.valueOf('\u00db'));
        escapes.put("Uuml", Character.valueOf('\u00dc'));
        escapes.put("Yacute", Character.valueOf('\u00dd'));
        escapes.put("THORN", Character.valueOf('\u00de'));
        escapes.put("szlig", Character.valueOf('\u00df'));
        escapes.put("agrave", Character.valueOf('\u00e0'));
        escapes.put("aacute", Character.valueOf('\u00e1'));
        escapes.put("acirc", Character.valueOf('\u00e2'));
        escapes.put("atilde", Character.valueOf('\u00e3'));
        escapes.put("auml", Character.valueOf('\u00e4'));
        escapes.put("aring", Character.valueOf('\u00e5'));
        escapes.put("aelig", Character.valueOf('\u00e6'));
        escapes.put("ccedil", Character.valueOf('\u00e7'));
        escapes.put("egrave", Character.valueOf('\u00e8'));
        escapes.put("eacute", Character.valueOf('\u00e9'));
        escapes.put("ecirc", Character.valueOf('\u00ea'));
        escapes.put("euml", Character.valueOf('\u00eb'));
        escapes.put("igrave", Character.valueOf('\u00ec'));
        escapes.put("iacute", Character.valueOf('\u00ed'));
        escapes.put("icirc", Character.valueOf('\u00ee'));
        escapes.put("iuml", Character.valueOf('\u00ef'));
        escapes.put("eth", Character.valueOf('\u00f0'));
        escapes.put("ntilde", Character.valueOf('\u00f1'));
        escapes.put("ograve", Character.valueOf('\u00f2'));
        escapes.put("oacute", Character.valueOf('\u00f3'));
        escapes.put("ocirc", Character.valueOf('\u00f4'));
        escapes.put("otilde", Character.valueOf('\u00f5'));
        escapes.put("ouml", Character.valueOf('\u00f6'));
        escapes.put("divide", Character.valueOf('\u00f7'));
        escapes.put("oslash", Character.valueOf('\u00f8'));
        escapes.put("ugrave", Character.valueOf('\u00f9'));
        escapes.put("uacute", Character.valueOf('\u00fa'));
        escapes.put("ucirc", Character.valueOf('\u00fb'));
        escapes.put("uuml", Character.valueOf('\u00fc'));
        escapes.put("yacute", Character.valueOf('\u00fd'));
        escapes.put("thorn", Character.valueOf('\u00fe'));
        escapes.put("yuml", Character.valueOf('\u00ff'));
    }
}

