/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.parser.doc;

import com.ibm.es.nuvo.crawler.web.parser.doc.AbstractParsedDocument;
import com.ibm.es.nuvo.crawler.web.parser.doc.Field;
import com.ibm.es.nuvo.crawler.web.parser.doc.Link;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLParsedDocument
extends AbstractParsedDocument {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + HTMLParsedDocument.class.getName());
    private List<Link> links;
    private List<String> frames;
    private List<Field> fields;
    private String base;
    private String encoding;
    private String redirectURL;
    private double feedVersion = -1.0;
    private boolean isHtml;
    private long hash;
    private static final String DEFAULT_ENCODING = System.getProperty("trevi.default.encoding", "ISO8859_1");

    public HTMLParsedDocument(String metaDataEncoding, List<Link> links, List<String> frames, List<Field> fields, String redirectURL, String base, String title, long date) {
        String initialEncoding;
        this.encoding = initialEncoding = this.determineInitialEncoding(metaDataEncoding);
        this.links = links;
        this.frames = frames;
        this.fields = fields;
        this.redirectURL = redirectURL;
        this.base = base;
        this.setTitle(title);
        this.setDate(date);
    }

    public HTMLParsedDocument() {
        this.links = new ArrayList<Link>();
        this.frames = new ArrayList<String>();
        this.fields = new ArrayList<Field>();
    }

    @Override
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public List<Link> getLinks() {
        return this.links;
    }

    public List<String> frames() {
        return this.frames;
    }

    @Override
    public String getBase() {
        return this.base;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getRedirectURL() {
        return this.redirectURL;
    }

    private String determineInitialEncoding(String metaDataEncoding) {
        try {
            if (metaDataEncoding != null && Charset.isSupported(metaDataEncoding)) {
                return metaDataEncoding;
            }
        }
        catch (IllegalCharsetNameException e) {
            if (tracer.isLoggable(Level.FINE)) {
                tracer.log(Level.FINE, metaDataEncoding, e);
            }
            return this.getDefaultEncoding();
        }
        return this.getDefaultEncoding();
    }

    private String getDefaultEncoding() {
        try {
            if (!Charset.isSupported(DEFAULT_ENCODING)) {
                try {
                    return Charset.forName("ISO8859_1").displayName();
                }
                catch (Exception e) {
                    return "ISO8859_1";
                }
            }
        }
        catch (IllegalCharsetNameException e) {
            return "ISO8859_1";
        }
        return DEFAULT_ENCODING;
    }

    public double getFeedVersion() {
        return this.feedVersion;
    }

    public void setRssVersion(double rssVersion) {
        this.feedVersion = rssVersion;
    }

    public boolean isFeed() {
        return this.feedVersion > 0.0;
    }

    public boolean isHtml() {
        return this.isHtml;
    }

    public void setFoundHtmlTag(boolean isHtml) {
        this.isHtml = isHtml;
    }

    public long getHash() {
        return this.hash;
    }

    public void setHash(long hash) {
        this.hash = hash;
    }
}

