/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.parser.doc;

public class Field {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public String name;
    public String[] values;
    public boolean searchable;
    public boolean fieldSearchable;
    public boolean metadata;
    public boolean parametricSearch;
    public boolean isContent;
    public int resolveConflict;
    public static final int METADATA_PREFERRED = 0;
    public static final int COEXIST = 1;
    public static final int CONTENT_PREFERRED = 2;
    static final String[] RESOLVE_STRING = new String[]{"MetadataPreferred", "Coexist", "ContentPreferred"};

    public Field(String fieldName, String[] valuesArg, boolean searchable, boolean fieldSearchable, boolean metadata, boolean parametricSearch, int resolveConflict, boolean isContent) {
        this.name = fieldName;
        this.values = new String[valuesArg.length];
        for (int i = 0; i < valuesArg.length; ++i) {
            this.values[i] = valuesArg[i];
        }
        this.searchable = searchable;
        this.fieldSearchable = fieldSearchable;
        this.metadata = metadata;
        this.parametricSearch = parametricSearch;
        this.resolveConflict = resolveConflict;
        this.isContent = isContent;
    }

    public Field(String fieldName, String value, boolean searchable, boolean fieldSearchable, boolean metadata, boolean parametricSearch, int resolveConflict, boolean isContent) {
        this.name = fieldName;
        this.values = new String[1];
        this.values[0] = value;
        this.searchable = searchable;
        this.fieldSearchable = fieldSearchable;
        this.metadata = metadata;
        this.parametricSearch = parametricSearch;
        this.resolveConflict = resolveConflict;
        this.isContent = isContent;
    }

    public Field(String name, String value) {
        this(name, value, true, true, true, false, 0, false);
    }

    public Field(String name, String[] values) {
        this(name, values, true, true, true, false, 0, false);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.values != null ? this.values[0] : null;
    }

    public String[] getValues() {
        String[] retValues = new String[this.values.length];
        System.arraycopy(this.values, 0, retValues, 0, this.values.length);
        return retValues;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public boolean isFieldSearchable() {
        return this.fieldSearchable;
    }

    public void setSearchable(boolean value) {
        this.searchable = value;
    }

    public void setFieldSearchable(boolean value) {
        this.fieldSearchable = value;
    }

    public boolean isMetadata() {
        return this.metadata;
    }

    public boolean isParametricSearch() {
        return this.parametricSearch;
    }

    public int resolveConflict() {
        return this.resolveConflict;
    }

    public boolean isContent() {
        return this.isContent;
    }

    public static int getResolveConflictID(String str) {
        for (int i = 0; i < RESOLVE_STRING.length; ++i) {
            if (!str.equalsIgnoreCase(RESOLVE_STRING[i])) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        builder.append(":");
        for (String value : this.values) {
            builder.append(value);
            builder.append(", ");
        }
        return builder.toString();
    }
}

