/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.net;

import com.ibm.es.nuvo.crawler.web.configuration.CrawlerConfig;
import com.ibm.es.nuvo.crawler.web.configuration.SSLConfig;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

class WCX509TrustManager
implements X509TrustManager {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static Logger logger = Loggers.logger;
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + WCX509TrustManager.class.getName());
    private long created;
    private String hostname;
    private SSLContext context;
    private X509TrustManager trustManager;

    WCX509TrustManager(X509TrustManager manager) throws NoSuchAlgorithmException, KeyManagementException {
        this.trustManager = manager;
        this.context = SSLContext.getInstance("TLS");
        this.context.init(null, new TrustManager[]{this}, null);
        this.created = System.currentTimeMillis();
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.trustManager != null) {
            this.trustManager.checkClientTrusted(chain, authType);
        }
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        SSLConfig.CertificationType type = CrawlerConfig.getInstance().getSslConfig().getType();
        try {
            if (this.trustManager != null) {
                this.trustManager.checkServerTrusted(chain, authType);
            }
            return;
        }
        catch (CertificateException ce) {
            String subject;
            if (SSLConfig.CertificationType.ALL.equals((Object)type)) {
                return;
            }
            if (chain == null || chain.length <= 0 || chain[0] == null) {
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.log(Level.FINE, "Invalid chain ");
                }
                throw ce;
            }
            String issuer = chain[0].getIssuerDN().getName();
            if (!issuer.equals(subject = chain[0].getSubjectDN().getName())) {
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.log(Level.FINE, "Not self signed ");
                }
                throw ce;
            }
            int cnIx = issuer.indexOf("CN=");
            int cmIx = issuer.indexOf(",", cnIx);
            if (cnIx < 0 || cmIx < 0) {
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.log(Level.FINE, "No name.");
                }
                throw ce;
            }
            String cnHostname = issuer.substring(cnIx + 3, cmIx).trim();
            if (!cnHostname.equals(this.hostname) && !cnHostname.startsWith(this.hostname)) {
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.log(Level.FINE, "Hostname missmatch. Expected " + this.hostname + " but " + cnHostname);
                }
                throw ce;
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "C4927W.SSL_FAIL", new Object[]{this.hostname, e});
            }
            throw new CertificateException("Error in custom cert checking");
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    public Socket createSocket(Socket socket, String name, int port) throws IOException {
        this.hostname = name;
        Socket createSocket = this.context.getSocketFactory().createSocket(socket, name, port, true);
        return createSocket;
    }

    public long getCreated() {
        return this.created;
    }
}

