/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.net;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.web.configuration.CrawlerConfig;
import com.ibm.es.nuvo.crawler.web.configuration.SSLConfig;
import com.ibm.es.nuvo.crawler.web.configuration.notify.ConfigChangeListener;
import com.ibm.es.nuvo.crawler.web.configuration.notify.ConfigEventBroaker;
import com.ibm.es.nuvo.crawler.web.error.ArgCheck;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.http.HTTPCategory;
import com.ibm.es.nuvo.crawler.web.http.fetcher.RestartableFetcher;
import com.ibm.es.nuvo.crawler.web.net.ReusableSocketManager;
import com.ibm.es.nuvo.crawler.web.net.TrustManagerCreateException;
import com.ibm.es.nuvo.crawler.web.net.WCX509TrustManager;
import com.ibm.es.nuvo.crawler.web.util.StreamUtils;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ClosedByInterruptException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Stack;
import java.util.logging.Level;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.cert.X509Certificate;

public class WCSSLSocketFactory
implements ConfigChangeListener {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static ExtendedLogger logger = Loggers.logger;
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + WCSSLSocketFactory.class.getName());
    private Stack<WCX509TrustManager> stack = new Stack();
    private SSLConfig sslConfig = CrawlerConfig.getInstance().getSslConfig();
    private static WCSSLSocketFactory factory = new WCSSLSocketFactory();
    private long lastUpdate;

    public static synchronized WCSSLSocketFactory getInstance() {
        if (factory == null) {
            factory = new WCSSLSocketFactory();
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public SSLSocket createSocket(String hostName, int portNo, InetSocketAddress isa, boolean forceDefault, int timeout, boolean proxy, String proxyCredential) throws IOException {
        SSLSocket socket = null;
        Socket normalSocket = null;
        boolean custom = this.useCustomManager() && !forceDefault;
        boolean forceSSL = false;
        boolean ok = false;
        int retryCount = 0;
        while (retryCount < 4) {
            block46: {
                block45: {
                    try {
                        Stack<WCX509TrustManager> stack;
                        normalSocket = ReusableSocketManager.openSocket(timeout, isa);
                        WCX509TrustManager manager = null;
                        int port = isa.getPort();
                        if (normalSocket == null) throw new SocketException("Underlying socket is not connected");
                        if (!normalSocket.isConnected()) {
                            throw new SocketException("Underlying socket is not connected");
                        }
                        if (proxy) {
                            this.connectToHost(hostName, portNo, normalSocket, timeout, proxyCredential);
                        }
                        try {
                            if (custom) {
                                stack = this.stack;
                                // MONITORENTER : stack
                                if (this.stack.size() > 0) {
                                    manager = this.stack.pop();
                                }
                                // MONITOREXIT : stack
                                if (manager == null) {
                                    manager = new WCX509TrustManager(this.getTrustManager());
                                }
                                socket = (SSLSocket)manager.createSocket(normalSocket, hostName, port);
                            } else {
                                socket = (SSLSocket)((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(normalSocket, hostName, port, true);
                            }
                            if (forceSSL) {
                                socket.setEnabledProtocols(new String[]{"SSLv3", "TLS"});
                            }
                            socket.startHandshake();
                        }
                        finally {
                            if (manager != null && manager.getCreated() > this.lastUpdate) {
                                stack = this.stack;
                            }
                        }
                        ok = true;
                        if (ok) return socket;
                        if (socket == null) break block45;
                    }
                    catch (ClosedByInterruptException ignored) {
                        if (ok) break block46;
                        if (socket != null) {
                            ReusableSocketManager.closeSocket(socket);
                            socket = null;
                        }
                        if (normalSocket != null) {
                            ReusableSocketManager.closeSocket(normalSocket);
                            normalSocket = null;
                        }
                        break block46;
                        catch (WCException e) {
                            ExtendedException exception;
                            Message message;
                            if (logger.isLoggable(Level.WARNING)) {
                                message = new Message("C4927W.SSL_FAIL", isa);
                                exception = new ExtendedException(message, (Throwable)e);
                                logger.log(Level.WARNING, exception);
                            }
                            break block46;
                            catch (GeneralSecurityException e2) {
                                if (logger.isLoggable(Level.WARNING)) {
                                    message = new Message("C4927W.SSL_FAIL", isa);
                                    exception = new ExtendedException(message, (Throwable)e2);
                                    logger.log(Level.WARNING, exception);
                                }
                                break block46;
                                catch (IOException e3) {
                                    block47: {
                                        X509Certificate[] certs;
                                        SSLSession sslSession;
                                        if (tracer.isLoggable(Level.FINE)) {
                                            message = new Message("C4927W.SSL_FAIL", isa);
                                            exception = new ExtendedException(message, (Throwable)e3);
                                            tracer.log(Level.FINE, exception);
                                        }
                                        if (socket != null && tracer.isLoggable(Level.FINER) && (sslSession = socket.getSession()) != null && (certs = sslSession.getPeerCertificateChain()) != null) {
                                            for (X509Certificate cert : certs) {
                                                tracer.finer("Peer cert notafter: " + cert.getNotAfter());
                                            }
                                        }
                                        if (!custom && forceSSL) {
                                            throw e3;
                                        }
                                        if (ok) break block46;
                                        if (socket == null) break block47;
                                        ReusableSocketManager.closeSocket(socket);
                                        socket = null;
                                    }
                                    if (normalSocket != null) {
                                        ReusableSocketManager.closeSocket(normalSocket);
                                        normalSocket = null;
                                    }
                                    break block46;
                                }
                            }
                        }
                    }
                    finally {
                        if (!ok) {
                            if (socket != null) {
                                ReusableSocketManager.closeSocket(socket);
                                socket = null;
                            }
                            if (normalSocket != null) {
                                ReusableSocketManager.closeSocket(normalSocket);
                                normalSocket = null;
                            }
                        }
                    }
                    ReusableSocketManager.closeSocket(socket);
                    socket = null;
                }
                if (normalSocket == null) return socket;
                ReusableSocketManager.closeSocket(normalSocket);
                return socket;
            }
            if (!custom && forceSSL) {
                return socket;
            }
            if (!forceSSL) {
                forceSSL = true;
            } else {
                custom = false;
                forceSSL = false;
            }
            ++retryCount;
        }
        return socket;
    }

    private void connectToHost(String hostName, int port, Socket socket, int timeout, String proxyCredential) throws WCException, IOException {
        OutputStream os = null;
        InputStream is = null;
        os = socket.getOutputStream();
        is = socket.getInputStream();
        StringBuilder buffer = new StringBuilder();
        buffer.append("CONNECT ").append(hostName).append(":").append(port).append(" HTTP/1.1\r\n");
        if (proxyCredential != null && proxyCredential.trim().length() > 0) {
            buffer.append(proxyCredential).append("\r\n");
        }
        buffer.append("Host: ").append(hostName).append("\r\n\r\n");
        os.write(buffer.toString().getBytes());
        os.flush();
        socket.setSoTimeout(timeout * 1000);
        byte[] header = RestartableFetcher.getHeader(is);
        if (tracer.isLoggable(Level.FINEST)) {
            tracer.finest(buffer.toString());
            if (header != null) {
                tracer.finest(new String(header));
            }
        }
        int code = 0;
        if (header != null) {
            code = RestartableFetcher.extractHTTPReturnCode(new String(header, "ISO8859-1"));
        }
        if (!HTTPCategory.successful(code)) {
            throw new IOException("Connection Not Established " + code);
        }
    }

    private WCSSLSocketFactory() {
        ConfigEventBroaker.register(ConfigEventBroaker.GLOBAL, this);
    }

    private boolean useCustomManager() {
        return !this.sslConfig.getType().equals((Object)SSLConfig.CertificationType.SYSTEM);
    }

    private File getKeystoreFile() {
        File f;
        String certPath = this.sslConfig.getCertPath();
        if (certPath != null && (f = new File(certPath)).canRead()) {
            return f;
        }
        String s = System.getProperty("java.home") + "/lib/security/cacerts";
        File f2 = new File(s);
        if (f2.canRead()) {
            return f2;
        }
        return null;
    }

    private char[] getKeystorePassword() throws WCException {
        if (this.sslConfig.getCertPath() != null) {
            String pw = this.sslConfig.getPassword();
            ArgCheck.nonWSState("keystore password", pw);
            return pw.toCharArray();
        }
        return "changeit".toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509TrustManager getTrustManager() throws WCException {
        try {
            String algo = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algo);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            if (tracer.isLoggable(Level.FINER)) {
                tracer.finer("KeyStore is " + keyStore);
            }
            if (keyStore != null) {
                FileInputStream is = null;
                try {
                    is = new FileInputStream(this.getKeystoreFile());
                    keyStore.load(is, this.getKeystorePassword());
                    tracer.log(Level.FINER, "KeyStore provider: " + keyStore.getProvider());
                }
                catch (Throwable throwable) {
                    StreamUtils.safeClose(is);
                    throw throwable;
                }
                StreamUtils.safeClose(is);
            }
            tracer.log(Level.FINER, "KeyStore loaded");
            tmf.init(keyStore);
            tracer.log(Level.FINER, "Trust manager factory initialized");
            TrustManager[] tma = tmf.getTrustManagers();
            if (tma != null) {
                for (TrustManager manager : tma) {
                    if (!(manager instanceof X509TrustManager)) continue;
                    return (X509TrustManager)manager;
                }
            }
        }
        catch (WCException we) {
            throw we;
        }
        catch (Exception e) {
            throw new TrustManagerCreateException(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChange() throws WCException {
        this.lastUpdate = System.currentTimeMillis();
        Stack<WCX509TrustManager> stack = this.stack;
        synchronized (stack) {
            this.stack.clear();
        }
    }
}

