/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.net;

import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.db.CrawlRec;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.crawler.web.net.ReusableSocket;
import com.ibm.es.nuvo.crawler.web.net.WCSSLSocketFactory;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import javax.net.SocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReusableSocketManager {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + ReusableSocketManager.class.getName());
    private HashMap<Hash64, ArrayList<ReusableSocket>> map = new HashMap();
    private static ReusableSocketManager instance = new ReusableSocketManager();

    public static ReusableSocketManager getInstance() {
        return instance;
    }

    private ReusableSocketManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReusableSocket getSocket(CrawlRec rec, int timeout, boolean proxy) throws IOException {
        ArrayList<ReusableSocket> list;
        CURL url = rec.getURL();
        ArrayList<ReusableSocket> arrayList = list = this.getList(url.getHostHash());
        synchronized (arrayList) {
            while (list.size() > 0) {
                ReusableSocket reusableSocket = list.remove(0);
                if (!reusableSocket.shouldClose()) {
                    if (tracer.isLoggable(Level.FINE)) {
                        tracer.log(Level.FINE, "reuse socket " + reusableSocket);
                    }
                    return reusableSocket;
                }
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.log(Level.FINE, "overdue socket " + reusableSocket);
                }
                reusableSocket.close();
            }
        }
        InetSocketAddress isa = rec.getBucket().nextInetSocketAddress();
        InetSocketAddress start = null;
        Socket socket = null;
        boolean secure = url.isSecure();
        while (true) {
            boolean ok = false;
            try {
                if (secure) {
                    for (int retryCount = 0; retryCount < 2; ++retryCount) {
                        try {
                            socket = WCSSLSocketFactory.getInstance().createSocket(url.getHostname(), url.getPort(), isa, retryCount > 0, timeout, proxy, rec.getBucket().getProxyAuth());
                            break;
                        }
                        catch (ClosedByInterruptException ignored) {
                            continue;
                        }
                        catch (IOException ioe) {
                            if (tracer.isLoggable(Level.FINER)) {
                                tracer.log(Level.FINER, "startHandshake(): ", ioe);
                            }
                            if (retryCount <= 0) continue;
                            throw ioe;
                        }
                    }
                } else {
                    socket = ReusableSocketManager.openSocket(timeout, isa);
                }
                ok = true;
            }
            catch (IOException e) {
                isa = rec.getBucket().nextInetSocketAddress();
                tracer.log(Level.FINER, "", e);
                if (isa == start || 1 == rec.getBucket().countIP()) {
                    throw e;
                }
                if (start != null) continue;
                start = isa;
                continue;
            }
            finally {
                if (ok) continue;
                ReusableSocketManager.closeSocket(socket);
                continue;
            }
            break;
        }
        if (socket == null) {
            return null;
        }
        return new ReusableSocket(socket, url.getHostHash());
    }

    static void waitForConnect(int timeout, InetSocketAddress isa, SocketChannel channel) throws IOException, SocketTimeoutException, InterruptedException {
        channel.configureBlocking(false);
        if (!channel.connect(isa)) {
            long limit = System.currentTimeMillis() + (long)timeout;
            while (!channel.finishConnect() && !Thread.currentThread().isInterrupted() && System.currentTimeMillis() < limit) {
                Thread.sleep(10L);
            }
            if (!channel.finishConnect()) {
                channel.close();
                if (System.currentTimeMillis() >= limit) {
                    throw new SocketTimeoutException("Connection Timeout " + (limit - System.currentTimeMillis()));
                }
            }
        }
        if (channel.isOpen()) {
            channel.configureBlocking(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnSocket(ReusableSocket socket) {
        if (socket == null) {
            return;
        }
        if (socket.shouldClose()) {
            if (tracer.isLoggable(Level.FINER)) {
                tracer.log(Level.FINE, "closing socket " + socket);
            }
            socket.close();
        } else {
            ArrayList<ReusableSocket> list;
            ArrayList<ReusableSocket> arrayList = list = this.getList(socket.getHostHash());
            synchronized (arrayList) {
                list.add(socket);
            }
            if (tracer.isLoggable(Level.FINE)) {
                tracer.log(Level.FINE, "return socket " + socket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Hash64 hostHash) {
        ArrayList<ReusableSocket> list;
        ArrayList<ReusableSocket> arrayList = list = this.getList(hostHash);
        synchronized (arrayList) {
            for (ReusableSocket socket : list) {
                socket.close();
            }
            list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ReusableSocket> getList(Hash64 hostHash) {
        ArrayList<ReusableSocket> list = this.map.get(hostHash);
        if (list == null) {
            HashMap<Hash64, ArrayList<ReusableSocket>> hashMap = this.map;
            synchronized (hashMap) {
                list = this.map.get(hostHash);
                if (list == null) {
                    list = new ArrayList(1);
                    this.map.put(hostHash, list);
                }
            }
        }
        return list;
    }

    static Socket openSocket(int timeout, InetSocketAddress isa) throws IOException {
        Socket socket = null;
        socket = SocketFactory.getDefault().createSocket();
        socket.connect(isa, timeout);
        return socket;
    }

    static void closeSocket(Socket socket) {
        if (socket == null) {
            return;
        }
        if (!socket.isClosed()) {
            try {
                if (!socket.isInputShutdown()) {
                    socket.shutdownInput();
                }
            }
            catch (IOException ignored) {
                ignored.printStackTrace();
            }
            catch (UnsupportedOperationException ignored) {
                // empty catch block
            }
            try {
                if (!socket.isOutputShutdown()) {
                    socket.shutdownOutput();
                }
            }
            catch (IOException ignored) {
                ignored.printStackTrace();
            }
            catch (UnsupportedOperationException ignored) {
                // empty catch block
            }
            try {
                socket.close();
            }
            catch (IOException ignored) {
                ignored.printStackTrace();
            }
        }
    }
}

