/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.net;

import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.net.ReusableSocketManager;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ReusableSocket {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private int count;
    private Socket socket;
    private long lastUsed;
    private int timeout;
    private boolean valid;
    private Hash64 hostHash;

    public ReusableSocket(Socket socket, Hash64 hostHash) {
        this.socket = socket;
        this.valid = true;
        this.count = 1;
        this.hostHash = hostHash;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Socket getSocket() {
        this.update();
        return this.socket;
    }

    public void update() {
        this.lastUsed = System.currentTimeMillis();
    }

    public boolean shouldClose() {
        return this.lastUsed > 0L && this.lastUsed + (long)((this.timeout - 1) * 1000) < System.currentTimeMillis() || this.count == 0 || !this.valid || this.socket.isInputShutdown() || this.socket.isOutputShutdown();
    }

    public void close() {
        ReusableSocketManager.closeSocket(this.socket);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.socket.toString());
        buffer.append(" ");
        buffer.append(SimpleDateFormat.getDateTimeInstance().format(new Date(this.lastUsed)));
        buffer.append(" ");
        buffer.append(this.timeout);
        buffer.append(" ");
        buffer.append(this.count);
        buffer.append(" ");
        buffer.append(this.valid);
        return buffer.toString();
    }

    public Hash64 getHostHash() {
        return this.hostHash;
    }
}

