/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.net;

import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.net.IPProto;
import com.ibm.es.nuvo.crawler.web.util.Strings;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CURL {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String S_INVALID = "invalid";
    public static final String S_UNCHECKED = "unknown";
    private String originalPath;
    private CURL context;
    private HashNormalizeLevel hashNormalizeLevel = HashNormalizeLevel.SORT;
    private String m_badString;
    private Hash64 m_hostHash;
    private Hash64 m_urlHash;
    protected Status m_status = Status.UNCHECKED;
    private String urlString;
    private int m_protocolNumber = -1;
    private String m_normProtocolName;
    private String m_normHostname;
    private int m_normPort = -1;
    private String m_normPath;
    private String m_normQuery;
    private String m_normRef;
    private static final Pattern _s_IPv4PatternWithoutPort = Pattern.compile("\\A(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)\\Z");
    private static final int[] legal = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 3, 0};
    private static final String[] replacementStrings = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0A", "%0B", "%0C", "%0D", "%0E", "%0F", "%11", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1A", "%1B", "%1C", "%1D", "%1E", "%1F", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2A", "%2B", "%2C", "%2D", "%2E", "%2F", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3A", "%3B", "%3C", "%3D", "%3E", "%3F", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4A", "%4B", "%4C", "%4D", "%4E", "%4F", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5A", "%5B", "%5C", "%5D", "%5E", "%5F", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6A", "%6B", "%6C", "%6D", "%6E", "%6F", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7A", "%7B", "%7C", "%7D", "%7E", "%7F"};

    public CURL(String urlString) {
        try {
            this.m_status = this._normalize(new URL(urlString));
            if (this.m_status == Status.OKAY) {
                this.m_badString = null;
            }
        }
        catch (MalformedURLException mue) {
            this.m_status = this._checkReasonForMalformedURLException(urlString);
            this.m_badString = urlString;
        }
    }

    private Status _checkReasonForMalformedURLException(String url) {
        try {
            if (url != null) {
                char c = url.charAt(0);
                if (c == '/') {
                    return Status.NO_PROTO;
                }
                if (url.toLowerCase().startsWith("javascript")) {
                    return Status.BAD_PROTO;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Status.MALFORMATTED_URL;
    }

    public CURL(CURL context, String urlString) {
        try {
            this.m_status = this._normalize(new URL(new URL(context.toString()), urlString));
            if (this.m_status == Status.OKAY) {
                this.m_badString = null;
            }
            if (urlString.startsWith("//")) {
                this.originalPath = urlString;
                this.context = context;
            }
        }
        catch (MalformedURLException mue) {
            this.m_status = this._checkReasonForMalformedURLException(urlString);
            this.m_badString = urlString;
        }
    }

    public String badString() {
        return this.m_badString;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        try {
            return ((CURL)other).getURLHash() == this.getURLHash();
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        return (int)(this.getURLHash().longValue() & 0xFFFFFFFFL);
    }

    public String getCookiePath() {
        if (this.m_status != Status.OKAY) {
            return null;
        }
        return this.m_normPath.substring(0, this.m_normPath.lastIndexOf(47) + 1);
    }

    public String getPath() {
        return this.m_status != Status.OKAY ? null : this.m_normPath;
    }

    public Hash64 getHostHash() {
        if (this.m_status != Status.OKAY) {
            return null;
        }
        if (this.m_hostHash == null) {
            this.m_hostHash = new Hash64(this.getRootURLString());
        }
        return this.m_hostHash;
    }

    public String getHostname() {
        return this.m_status != Status.OKAY ? null : this.m_normHostname;
    }

    public int getPort() {
        return this.m_status != Status.OKAY ? -1 : this.m_normPort;
    }

    public String getProtocol() {
        return this.m_status != Status.OKAY ? null : this.m_normProtocolName;
    }

    public int getProtocolNumber() {
        return this.m_status != Status.OKAY ? -1 : this.m_protocolNumber;
    }

    public String getRootURLString() {
        if (this.m_status != Status.OKAY) {
            return null;
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.m_normProtocolName).append("://").append(this.m_normHostname);
        if (!this.isStandaradPort()) {
            sb.append(":").append(this.m_normPort);
        }
        sb.append("/");
        return sb.toString();
    }

    public String getServerLocalPart() {
        if (this.m_status != Status.OKAY) {
            return null;
        }
        StringBuilder sb = new StringBuilder(512);
        sb.append(this.m_normPath);
        if (this.m_normQuery != null) {
            sb.append("?").append(this.m_normQuery);
        }
        return sb.toString();
    }

    public Status getStatus() {
        return this.m_status;
    }

    public Hash64 getURLHash() {
        if (this.m_status != Status.OKAY) {
            return null;
        }
        if (this.m_urlHash == null) {
            this.m_urlHash = new Hash64(this._hashableSpec());
        }
        return this.m_urlHash;
    }

    public boolean isRobots() {
        if (this.m_status != Status.OKAY) {
            return false;
        }
        return this.m_normPath.endsWith("/robots.txt");
    }

    public boolean isSecure() {
        if (this.m_status != Status.OKAY) {
            return false;
        }
        return this.m_protocolNumber == 1;
    }

    public boolean isValid() {
        return this.m_status == Status.OKAY;
    }

    public boolean mayBeRelative() {
        return this.m_status == Status.NO_PROTO || this.m_status == Status.MALFORMATTED_URL;
    }

    public String toString() {
        if (this.urlString != null) {
            return this.urlString;
        }
        if (this.m_status == Status.OKAY) {
            this.urlString = this._generateString(Format.CANONICAL);
            return this.urlString;
        }
        if (this.m_status == Status.UNCHECKED) {
            return S_UNCHECKED;
        }
        return S_INVALID;
    }

    public String downstreamString() {
        if (this.m_status == Status.OKAY) {
            return this._generateString(Format.DOWNSTREAM);
        }
        if (this.m_status == Status.UNCHECKED) {
            return S_UNCHECKED;
        }
        return S_INVALID;
    }

    private String _hashableSpec() {
        return this.m_status != Status.OKAY ? null : this._generateString(Format.HASHABLE);
    }

    private String _generateString(Format kindOfString) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.m_normProtocolName);
        sb.append("://").append(this.m_normHostname);
        if (kindOfString != Format.DOWNSTREAM || !this.isStandaradPort()) {
            sb.append(":").append(this.m_normPort);
        }
        sb.append(this.m_normPath);
        if (this.m_normQuery != null) {
            sb.append("?");
            if (Format.HASHABLE == kindOfString) {
                sb.append(this.getParamsForHash());
            } else {
                sb.append(this.m_normQuery);
            }
        }
        if (kindOfString != Format.HASHABLE && kindOfString != Format.DOWNSTREAM && this.m_normRef != null) {
            sb.append("#").append(this.m_normRef);
        }
        return sb.toString();
    }

    public boolean isStandaradPort() {
        return this.m_normPort == IPProto.getStandardPort(this.m_protocolNumber);
    }

    private String getParamsForHash() {
        if (this.hashNormalizeLevel == HashNormalizeLevel.OFF) {
            return this.m_normQuery;
        }
        StringBuilder builder = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(this.m_normQuery, "&");
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        if (list.size() < 2) {
            return this.m_normQuery;
        }
        Collections.sort(list);
        for (String param : list) {
            if (builder.length() > 0) {
                builder.append("&");
            }
            builder.append(param);
        }
        return builder.toString();
    }

    private Status _normalize(URL url) {
        byte[] ba;
        String string = this.m_badString = url == null ? "null" : url.toString();
        if (url == null) {
            return Status.UNCHECKED;
        }
        if (url.getUserInfo() != null) {
            return Status.USER_INFO;
        }
        if (Strings.isWSN(url.getProtocol())) {
            return Status.NO_PROTO;
        }
        this.m_protocolNumber = IPProto.getProtocolNumber(url.getProtocol());
        if (this.m_protocolNumber < 0) {
            return Status.BAD_PROTO;
        }
        this.m_normProtocolName = IPProto.getProtocolName(this.m_protocolNumber);
        if (Strings.isWSN(this.m_normProtocolName)) {
            return Status.BAD_PROTO;
        }
        String s = url.getHost();
        if (Strings.isWSN(s)) {
            return Status.NO_HOST;
        }
        this.m_normHostname = s.toLowerCase();
        if (this.m_normHostname.indexOf(64) >= 0 || this.m_normHostname.indexOf(47) >= 0) {
            return Status.INV_HOST_CHAR;
        }
        this.m_normPort = url.getPort();
        if (this.m_normPort == -1) {
            this.m_normPort = url.getDefaultPort();
        }
        if (this.m_normPort < 0) {
            return Status.NO_PORT;
        }
        Status[] ec = new Status[]{Status.UNCHECKED};
        this.m_normPath = this._normalizePath(url.getPath(), ec);
        if (this.m_normPath == null) {
            return ec[0];
        }
        try {
            this.m_normQuery = url.getQuery();
            this.m_normRef = url.getRef();
            if (this.m_normQuery != null) {
                this.m_normQuery = CURL._curlEncode(this.m_normQuery, 2);
            }
            if (this.m_normRef != null) {
                this.m_normRef = CURL._curlEncode(this.m_normRef, 1);
            }
        }
        catch (Exception e) {
            return Status.QUERY_OR_REF;
        }
        try {
            ba = this.m_normHostname.getBytes("UTF-8");
            if (ba != null && ba.length > 255) {
                return Status.HOST_LENGTH;
            }
        }
        catch (UnsupportedEncodingException ignored) {
            // empty catch block
        }
        try {
            this.urlString = this._generateString(Format.CANONICAL);
            byte[] byArray = ba = this.urlString != null ? this.urlString.getBytes("UTF-8") : null;
            if (ba != null && ba.length > 4096) {
                return Status.LENGTH;
            }
        }
        catch (UnsupportedEncodingException ignored) {
            // empty catch block
        }
        if (this._convertNumericHostToRawAddress() != null) {
            return Status.OKAY;
        }
        int dot = this.m_normHostname.lastIndexOf(46);
        if (dot < 0) {
            return Status.OKAY;
        }
        return Status.OKAY;
    }

    private byte[] _convertNumericHostToRawAddress() {
        Matcher m;
        if (this.m_status != Status.UNCHECKED) {
            return null;
        }
        if (this.m_normHostname.charAt(0) == '[') {
            try {
                this.m_status = Status.OKAY;
                return InetAddress.getByName(this.m_normHostname).getAddress();
            }
            catch (Exception e) {
                this.m_status = Status.INVALID_IPV6_FORMAT;
                return null;
            }
        }
        if (Character.isDigit(this.m_normHostname.charAt(0)) && (m = _s_IPv4PatternWithoutPort.matcher(this.m_normHostname)).find()) {
            byte[] octets = new byte[4];
            try {
                for (int j = 1; j <= 4; ++j) {
                    int v = Integer.parseInt(m.group(j));
                    if (v < 0 || v > 255) {
                        this.m_status = Status.INVALID_IPV4_FORMAT;
                        return null;
                    }
                    octets[j - 1] = (byte)v;
                }
                this.m_status = Status.OKAY;
                return octets;
            }
            catch (NumberFormatException nfe) {
                this.m_status = Status.INVALID_IPV4_FORMAT;
                return null;
            }
        }
        return null;
    }

    private static String _curlEncode(String s, int m) throws UnsupportedEncodingException {
        if (s == null || s.length() == 0) {
            return s;
        }
        char[] ca = s.toCharArray();
        return CURL._curlEncode(ca, 0, ca.length, m);
    }

    private static String _curlEncode(char[] ca, int start, int end, int m) throws UnsupportedEncodingException {
        int initsize = end - start;
        if (initsize < 128) {
            initsize = 128;
        } else if (initsize > 1024) {
            initsize = 1024;
        }
        StringBuilder sb = new StringBuilder(initsize);
        char c = '\u0000';
        for (int j = start; j < end; ++j) {
            c = ca[j];
            if (c < '\u0000' || c > '\u007f') {
                sb.append(URLEncoder.encode("" + c, "UTF-8"));
                continue;
            }
            if ((legal[c] & m) != 0) {
                sb.append(c);
                continue;
            }
            if (c == '%') {
                if (j + 2 < end) {
                    char c2 = ca[j + 1];
                    char c3 = ca[j + 2];
                    if (c2 >= '\u0000' && c2 <= '\u007f' && c3 >= '\u0000' && c3 <= '\u007f') {
                        sb.append("%").append(c2).append(c3);
                        j += 2;
                        continue;
                    }
                    sb.append("%25");
                    continue;
                }
                sb.append("%25");
                continue;
            }
            sb.append(replacementStrings[c]);
        }
        return sb.toString();
    }

    private String _normalizePath(String path, Status[] ec) {
        if (Strings.isWSN(path)) {
            path = "/";
        }
        char[] ca = path.toCharArray();
        int wi = 0;
        int st = 0;
        block2: for (int ri = 0; ri < ca.length; ++ri) {
            char rc = ca[ri];
            if (rc == '/') {
                if (st == 0) {
                    st = 1;
                    if (ri != wi) {
                        ca[wi] = rc;
                    }
                    ++wi;
                    continue;
                }
                if (st == 1) continue;
                if (st == 2) {
                    st = 1;
                    continue;
                }
                if (st != 3) continue;
                st = 1;
                for (int k = wi - 2; k >= 0; --k) {
                    if (ca[k] != '/') continue;
                    wi = k + 1;
                    continue block2;
                }
                continue;
            }
            if (rc == '.') {
                if (st == 0) {
                    if (ri != wi) {
                        ca[wi] = rc;
                    }
                    ++wi;
                    continue;
                }
                if (st == 1) {
                    st = 2;
                    continue;
                }
                if (st == 2) {
                    st = 3;
                    continue;
                }
                if (st != 3) continue;
                st = 0;
                if (ri != wi) {
                    ca[wi] = 46;
                    ca[wi + 1] = 46;
                    ca[wi + 2] = 46;
                }
                wi += 3;
                continue;
            }
            if (st == 0) {
                if (ri != wi) {
                    ca[wi] = rc;
                }
                ++wi;
                continue;
            }
            if (st == 1) {
                st = 0;
                if (ri != wi) {
                    ca[wi] = rc;
                }
                ++wi;
                continue;
            }
            if (st == 2) {
                st = 0;
                if (ri != wi) {
                    ca[wi] = 46;
                    ca[wi + 1] = rc;
                }
                wi += 2;
                continue;
            }
            if (st != 3) continue;
            st = 0;
            if (ri != wi) {
                ca[wi] = 46;
                ca[wi + 1] = 46;
                ca[wi + 2] = rc;
            }
            wi += 3;
        }
        if (st == 3) {
            for (int k = wi - 2; k >= 0; --k) {
                if (ca[k] != '/') continue;
                wi = k + 1;
                break;
            }
        }
        try {
            return CURL._curlEncode(ca, 0, wi, 1);
        }
        catch (Exception e) {
            ec[0] = Status.PATH_ENCODING;
            return null;
        }
    }

    public void setHashNormalizeLevel(HashNormalizeLevel hashNormalizeLevel) {
        this.hashNormalizeLevel = hashNormalizeLevel;
        this.m_urlHash = null;
    }

    public String getOriginalPath() {
        return this.originalPath;
    }

    public CURL getContext() {
        return this.context;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Status {
        UNCHECKED,
        OKAY,
        USER_INFO,
        NO_PROTO,
        BAD_PROTO,
        NO_HOST,
        INV_HOST_CHAR,
        NO_PORT,
        QUERY_OR_REF,
        TLD,
        MALFORMATTED_URL,
        PATH_ENCODING,
        INVALID_IPV6_FORMAT,
        INVALID_IPV4_FORMAT,
        LENGTH,
        HOST_LENGTH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HashNormalizeLevel {
        OFF,
        SORT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Format {
        CANONICAL,
        DOWNSTREAM,
        HASHABLE;

    }
}

