/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.log;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.web.http.DownloadFailedException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;

public class LogFormatter
extends Formatter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    static String nl = System.getProperty("line.separator");
    DateFormat dateFormat = DateFormat.getDateTimeInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(LogRecord record) {
        Object[] params;
        Date date = new Date(record.getMillis());
        StringBuffer buffer = new StringBuffer();
        DateFormat dateFormat = this.dateFormat;
        synchronized (dateFormat) {
            buffer.append(this.dateFormat.format(date));
        }
        buffer.append(" [").append((record.getLevel().getName() + "      ").substring(0, 6)).append("] ").append((Thread.currentThread().getName().trim() + "        ").substring(0, 8)).append(" ");
        String sourceClassName = record.getSourceClassName();
        int j = sourceClassName.lastIndexOf(".");
        buffer.append(j < 0 ? sourceClassName : sourceClassName.substring(j + 1));
        String message = record.getMessage();
        String string = Message.getText(message, Locale.ENGLISH);
        boolean param = true;
        if (string != null) {
            param = false;
            Object[] parameters = record.getParameters();
            if (parameters == null && record.getThrown() != null && record.getThrown() instanceof ExtendedException) {
                message = ((ExtendedException)record.getThrown()).getFormattedText();
            } else if (parameters != null) {
                message = MessageFormat.format(string, parameters);
            }
            if (parameters != null) {
                for (Object obj : parameters) {
                    if (!(obj instanceof Exception) || obj instanceof DownloadFailedException || obj instanceof SSLException) continue;
                    Throwable e = (Exception)obj;
                    if (!Logger.getLogger(LogFormatter.class.getName()).isLoggable(Level.FINE)) continue;
                    e.printStackTrace();
                    while ((e = e.getCause()) != null) {
                        e.printStackTrace();
                    }
                }
            }
        }
        buffer.append("#").append(record.getSourceMethodName()).append(" ").append(message).append(nl);
        Throwable throwable = record.getThrown();
        if (throwable != null) {
            StringWriter writer = new StringWriter();
            throwable.printStackTrace(new PrintWriter(writer));
            buffer.append(writer.toString());
        }
        if (param && (params = record.getParameters()) != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                buffer.append("%").append(i).append(" : ").append(params[i] == null ? "null" : params[i].toString()).append(nl);
            }
        }
        return buffer.toString();
    }
}

